# GENERIC METHODS
NULL

# API ==========================================================================
#' Download Documents
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param destination A [`character`] string giving the directory path where
#'  the downloaded files are to be saved.
#' @param limit An [`integer`] giving the maximum number of results.
#'  According to HAL policy, it cannot exceed 10000.
#' @param start An [`integer`] specifying an absolute offset in the complete
#'  sorted list of matches to be used as the beginning of the current page.
#'  Only used if `cursor` is `FALSE`.
#' @param progress A [`logical`] scalar: should a progress bar for for the
#'  request be printed?
#' @param verbose A [`logical`] scalar: should extra information be reported?
#' @param ... Currently not used.
#' @return
#'  Invisibly returns `destination`.
#' @example inst/examples/ex-download.R
#' @author N. Frerebeau
#' @docType methods
#' @family search tools
#' @export
hal_download <- function(query, ...) UseMethod("hal_download")

#' Search
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @inheritParams hal_endpoint
#' @param limit An [`integer`] giving the maximum number of results.
#'  According to HAL policy, it cannot exceed 10000.
#' @param start An [`integer`] specifying an absolute offset in the complete
#'  sorted list of matches to be used as the beginning of the current page.
#'  Only used if `cursor` is `FALSE`.
#' @param cursor A [`logical`] scalar: should a cursor be used for
#'  the pagination of results? If `TRUE`, the \code{sort} parameter of the
#'  query will set to "\code{docid asc}".
#' @param max_requests An [`integer`] specifying the maximum number of requests
#'  to perform. Use `Inf` to perform all requests. Only used if `cursor` is
#'  `TRUE`.
#' @param on_error A [`character`] string specifying what should happen if a
#'  request fails (see [httr2::req_perform_iterative()]). Only used if `cursor`
#'  is `TRUE`.
#' @param progress A [`logical`] scalar: should a progress bar for
#'  for the request be printed?
#' @param verbose A [`logical`] scalar: should extra information be reported?
#' @param ... Currently not used.
#' @return
#'  A [`list`] of class `HALSearch`.
#' @references
#'  [Apache Solr documentation](https://solr.apache.org/).
#'
#'  [HAL search documentation](https://api.archives-ouvertes.fr/docs/search).
#'
#'  [HAL reference frame documentation](https://api.archives-ouvertes.fr/docs/ref).
#' @example inst/examples/ex-search.R
#' @author N. Frerebeau
#' @family search tools
#' @export
hal_search <- function(query, ...) UseMethod("hal_search")

#' Count
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @inheritParams hal_endpoint
#' @param ... Currently not used.
#' @return
#'  An [`integer`] (the number of results).
#' @example inst/examples/ex-search.R
#' @author N. Frerebeau
#' @family search tools
#' @export
hal_count <- function(query, ...) UseMethod("hal_count")

# Results ======================================================================
#' Coerce to a Data Frame
#'
#' Coerce to a [`data.frame`], if possible.
#' @param x An object of class `HALSearch` (typically returned by [hal_search()]).
#' @param ... Currently not used.
#' @return
#'  A [`data.frame`].
#' @example inst/examples/ex-search.R
#' @author N. Frerebeau
#' @family results
#' @name as.data.frame
#' @rdname as.data.frame
NULL

# Query ========================================================================
## Faceting --------------------------------------------------------------------
#' Facet Search
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param field A [`character`] string specifying the field to group by.
#' @param limit An [`integer`] giving the maximum number of results per group.
#' @param sort A [`character`] string specifying the field to be used to sort
#'  the results.
#' @param prefix A [`character`] string.
#' @param contains A [`character`] string.
#' @param pivot A [`character`] string.
#' @param range A [`list`] containing the following components: "`range`",
#'  "`start`", "`end`", "`gap`".
#' @param ignore_case A [`logical`] scalar: should character case be ignored?
#' @param ... Currently not used.
#' @return An object of class [`HALQuery`][hal_query()].
#' @example inst/examples/ex-facet.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @export
hal_facet <- function(query, ...) UseMethod("hal_facet")

## Filter ----------------------------------------------------------------------
#' Filter Results
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param value A [`character`] string specifying the value to be used to filter
#'  the results.
#' @param field A [`character`] string specifying the field to filter along.
#' @param ... Currently not used.
#' @return An object of class [`HALQuery`][hal_query()].
#' @example inst/examples/ex-filter.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @export
hal_filter <- function(query, ...) UseMethod("hal_filter")

## Group -----------------------------------------------------------------------
#' Group Results
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param field A [`character`] string specifying the field to group by.
#' @param limit An [`integer`] giving the maximum number of results per group.
#' @param sort A [`character`] string specifying the field to be used to sort
#'  the results.
#' @param decreasing A [`logical`] scalar: should the sort be increasing or
#'  decreasing?
#' @param ... Currently not used.
#' @return An object of class [`HALQuery`][hal_query()].
#' @example inst/examples/ex-group.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @export
hal_group <- function(query, ...) UseMethod("hal_group")

## Operators -------------------------------------------------------------------
#' Operators
#'
#' @param x,y A (`list` of) [`character`] vector.
#' @return A [`character`] string.
#' @example inst/examples/ex-operators.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @name operators
#' @rdname operators
NULL

## Select ----------------------------------------------------------------------
#' Select Fields
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param ... One or more [`character`] string separated by commas giving the
#'  fields to be returned.
#' @return An object of class [`HALQuery`][hal_query()].
#' @example inst/examples/ex-select.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @export
hal_select <- function(query, ...) UseMethod("hal_select")

## Sort ------------------------------------------------------------------------
#' Sort Results
#'
#' @param query An object of class `HALQuery` (typically returned by [hal_query()]).
#' @param field A [`character`] string specifying the field to be used to sort
#'  the results.
#' @param decreasing A [`logical`] scalar: should the sort be increasing or
#'  decreasing?
#' @param ... Currently not used.
#' @return An object of class [`HALQuery`][hal_query()].
#' @example inst/examples/ex-sort.R
#' @author N. Frerebeau
#' @docType methods
#' @family query tools
#' @export
hal_sort <- function(query, ...) UseMethod("hal_sort")
