% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_tad.R
\name{calculate_tad}
\alias{calculate_tad}
\title{Calculate time after dose for pharmacokinetic data}
\usage{
calculate_tad(dat, verbose = FALSE)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{verbose}{Logical; if TRUE, prints informational messages during
processing (e.g., when generating dose numbers). Default is FALSE.}
}
\value{
A modified data frame with added columns:
\itemize{
\item tad: time after dose, calculated as the observation time minus the time
of the most recent prior dose; set to NA for dosing records
\item iiobs: interdose interval inherited from the most recent dosing record
\item rateobs: infusion rate inherited from the most recent dosing record
\item routeobs (optional): route of administration inherited from the most
recent dosing record, included only if route information is present
\item dose_number: sequential dose number, generated if not already present
}
}
\description{
Calculate time after dose (TAD) for pharmacokinetic observations.
}
\details{
The procedure identifies dosing events based on the event identifier (EVID)
and assigns each observation the attributes of the most recent prior dose.
The time after dose is then calculated for observation rows. If \code{dose_number}
column is not present in the input, it is automatically created for each subject.
}
\examples{
calculate_tad(Bolus_1CPT)
calculate_tad(Infusion_1CPT)
calculate_tad(Oral_1CPT)

}
\author{
Zhonghui Huang
}
