% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{cluster_searchlight_series}
\alias{cluster_searchlight_series}
\title{Cluster-centroid searchlight over cluster time-series}
\usage{
cluster_searchlight_series(x, cvol = NULL, k = 10L, radius = NULL, label = "")
}
\arguments{
\item{x}{A `ClusteredNeuroVec` object or a `NeuroVec` plus `cvol`}

\item{cvol}{A `ClusteredNeuroVol` (required if `x` is a `NeuroVec`)}

\item{k}{Integer, number of nearest clusters including the seed (default: 10).
Will be capped at the total number of clusters if specified value exceeds it.}

\item{radius}{Numeric distance in mm. If given, use all clusters within this radius
instead of k-nearest neighbors. Cannot be used together with \code{k}.}

\item{label}{Optional character label for the returned windows}
}
\value{
A list of \code{ROIVec} objects, one per cluster, where each ROIVec contains:
\describe{
  \item{values}{A TxN matrix where T is the number of timepoints and N is the number
    of neighboring clusters (including the seed itself)}
  \item{coords}{The centroid coordinates of the neighboring clusters}
}
The seed cluster's time-series is always the first column in each ROIVec.
}
\description{
Iterate over clusters by their centroids and, for each seed cluster, return the
time-series of the K nearest clusters (or those within a radius). This enables
searchlight analysis at the cluster level rather than individual voxels.
}
\details{
The function creates a searchlight around each cluster's centroid, selecting either:
\itemize{
  \item The k nearest clusters (when \code{k} is specified)
  \item All clusters within a given radius (when \code{radius} is specified)
}

This is particularly useful for cluster-level connectivity analyses or when
working with parcellated data where voxel-level searchlights would be redundant.
}
\examples{
# Create synthetic 4D data (8x8x8 volume, 10 timepoints)
sp4 <- NeuroSpace(c(8,8,8,10), c(1,1,1))
arr <- array(rnorm(8*8*8*10), dim=c(8,8,8,10))
vec <- NeuroVec(arr, sp4)

# Create a mask covering most of the volume
sp3 <- NeuroSpace(c(8,8,8), c(1,1,1))
mask_arr <- array(FALSE, dim=c(8,8,8))
mask_arr[2:7, 2:7, 2:7] <- TRUE
mask <- LogicalNeuroVol(mask_arr, sp3)

# Assign voxels to 10 clusters
n_voxels <- sum(mask_arr)
clusters <- sample(1:10, n_voxels, replace=TRUE)
cvol <- ClusteredNeuroVol(mask, clusters)

# Create clustered representation
cv <- ClusteredNeuroVec(vec, cvol)

# Get cluster searchlight with 3 nearest neighbors
windows <- cluster_searchlight_series(cv, k = 3)
length(windows)  # 10 windows (one per cluster)

# Check first window
roi1 <- windows[[1]]
dim(values(roi1))  # 10 x 3 (timepoints x neighbors)

# Use radius-based neighborhoods (5mm radius)
windows_radius <- cluster_searchlight_series(cv, radius = 5)
# Each window may have different number of neighbors
}
\seealso{
\code{\link{ClusteredNeuroVec}} for creating clustered neuroimaging vectors,
\code{\link{searchlight}} for voxel-level searchlight analysis,
\code{\link{ROIVec}} for the structure of returned windows
}
