% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjmat.r
\name{isolated}
\alias{isolated}
\alias{drop_isolated}
\title{Find and remove isolated vertices}
\usage{
isolated(
  graph,
  undirected = getOption("diffnet.undirected", FALSE),
  self = getOption("diffnet.self", FALSE)
)

drop_isolated(
  graph,
  undirected = getOption("diffnet.undirected", FALSE),
  self = getOption("diffnet.self", FALSE)
)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{undirected}{Logical scalar. When \code{TRUE} only the lower triangle of the adjacency matrix will considered (faster).}

\item{self}{Logical scalar. When \code{TRUE} autolinks (loops, self edges) are allowed (see details).}
}
\value{
When \code{graph} is an adjacency matrix:
 \item{isolated}{an matrix of size \eqn{n\times 1}{n*1} with 1's where a node is isolated}
 \item{drop_isolated}{a modified graph excluding isolated vertices.}

Otherwise, when \code{graph} is a list
 \item{isolated}{an matrix of size \eqn{n\times T}{n*T} with 1's where a node is isolated}
 \item{drop_isolated}{a modified graph excluding isolated vertices.}
}
\description{
Find and remove unconnected vertices from the graph.
}
\examples{
# Generating random graph
set.seed(123)
adjmat <- rgraph_er()

# Making nodes 1 and 4 isolated
adjmat[c(1,4),] <- 0
adjmat[,c(1,4)] <- 0
adjmat

# Finding isolated nodes
iso <- isolated(adjmat)
iso

# Removing isolated nodes
drop_isolated(adjmat)


# Now with a dynamic graph
graph <- rgraph_er(n=10, t=3)

# Making 1 and 5 isolated
graph <- lapply(graph, "[<-", i=c(1,5), j=1:10, value=0)
graph <- lapply(graph, "[<-", i=1:10, j=c(1,5), value=0)
graph

isolated(graph)
drop_isolated(graph)
}
\seealso{
Other data management functions: 
\code{\link{diffnet-class}},
\code{\link{edgelist_to_adjmat}()},
\code{\link{egonet_attrs}()},
\code{\link{survey_to_diffnet}()}
}
\author{
George G. Vega Yon
}
\concept{data management functions}
\keyword{manip}
