% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_diff_values.R
\name{extract_diff_values}
\alias{extract_diff_values}
\title{Extract Different Values
Function to extract rows with different values between two data frames.}
\usage{
extract_diff_values(
  dfx = NULL,
  dfy = NULL,
  myrror_object = NULL,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  output = c("simple", "full", "silent"),
  tolerance = 0.0000001,
  verbose = getOption("myrror.verbose"),
  interactive = getOption("myrror.interactive")
)
}
\arguments{
\item{dfx}{a non-empty data.frame.}

\item{dfy}{a non-empty data.frame.}

\item{myrror_object}{myrror object from \link{create_myrror_object}}

\item{by}{character, key to be used for dfx and dfy.}

\item{by.x}{character, key to be used for dfx.}

\item{by.y}{character, key to be used for dfy.}

\item{output}{character: one of "full", "simple", "silent".}

\item{tolerance}{numeric, default to 1e-7.}

\item{verbose}{logical: If \code{TRUE} additional information will be displayed.}

\item{interactive}{logical: If \code{TRUE}, print S3 method for myrror objects
displays by chunks. If \code{FALSE}, everything will be printed at once.}
}
\value{
Depending on \code{output} parameter:
\itemize{
\item \code{"full"}: myrror object with \code{extract_diff_values} slot containing a list with \code{diff_list} and \code{diff_table}
\item \code{"simple"}: named list of data.tables, one per variable with differences. Each table contains columns: diff, indexes, keys, variable.x, variable.y
\item \code{"silent"}: invisibly returns myrror object (same as "full")
}
Returns \code{NULL} if no differences are found and \code{output = "simple"}.
}
\description{
Extract Different Values
Function to extract rows with different values between two data frames.
}
\examples{

# 1. Standard report, after running myrror() or compare_values():
myrror(survey_data, survey_data_2, by=c('country', 'year'))
extract_diff_values()

# 2. Standard report, with new data:
extract_diff_values(survey_data, survey_data_2, by=c('country', 'year'))

# 3. Toggle tolerance:
extract_diff_values(survey_data, survey_data_2, by=c('country', 'year'),
                    tolerance = 1e-5)

}
