% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{Dialog}
\alias{Dialog}
\title{Dialog}
\usage{
Dialog(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/dialog/}
}
\details{
\itemize{
\item open \code{bool} \cr Default is - If true, the component is shown.
\item aria-describedby \code{string} \cr Default is - The id(s) of the element(s) that describe the dialog.
\item aria-labelledby \code{string} \cr Default is - The id(s) of the element(s) that label the dialog.
\item aria-modal \code{'false'| 'true'| bool} \cr Default is TRUE Informs assistive technologies that the element is modal. It's added on the element with role="dialog".
\item BackdropComponent \code{elementType} \cr Default is styled(Backdrop, name: 'MuiModal', slot: 'Backdrop', overridesResolver: (props, styles) = return styles.backdrop; , )( zIndex: -1, ) A backdrop component. This prop enables custom backdrop rendering.Deprecated Use slots.backdrop instead. While this prop currently works, it will be removed in the next major version.
\item children \code{node} \cr Default is - Dialog children, usually the included sub-components.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item disableEscapeKeyDown \code{bool} \cr Default is FALSE If true, hitting escape will not fire the onClose callback.
\item fullScreen \code{bool} \cr Default is FALSE If true, the dialog is full-screen.
\item fullWidth \code{bool} \cr Default is FALSE If true, the dialog stretches to maxWidth.Notice that the dialog width grow is limited by the default margin.
\item maxWidth \code{'xs'| 'sm'| 'md'| 'lg'| 'xl'| false| string} \cr Default is 'sm' Determine the max-width of the dialog. The dialog width grows with the size of the screen. Set to false to disable maxWidth.
\item onClose \code{func} \cr Default is - Callback fired when the component requests to be closed.Signature:function(event: object, reason: string) = voidevent The event source of the callback.reason Can be: "escapeKeyDown", "backdropClick".
\item PaperComponent \code{elementType} \cr Default is Paper The component used to render the body of the dialog.
\item PaperProps \code{object} \cr Default is Props applied to the Paper element.Deprecated Use slotProps.paper instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item scroll \code{'body'| 'paper'} \cr Default is 'paper' Determine the container for scrolling the dialog.
\item slotProps \verb{\{ backdrop?: func| object, container?: func| object, paper?: func| object, root?: func| object, transition?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ backdrop?: elementType, container?: elementType, paper?: elementType, root?: elementType, transition?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item TransitionComponent \code{elementType} \cr Default is Fade The component used for the transition. Follow this guide to learn more about the requirements for this component.Deprecated Use slots.transition instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item transitionDuration \verb{number| \{ appear?: number, enter?: number, exit?: number \}} \cr Default is enter: theme.transitions.duration.enteringScreen, exit: theme.transitions.duration.leavingScreen, The duration for the transition, in milliseconds. You may specify a single timeout for all transitions, or individually with an object.
\item TransitionProps \code{object} \cr Default is - Props applied to the transition element. By default, the element is based on this Transition component.Deprecated Use slotProps.transition instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
}
}
