% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{validate_database_schema_exists}
\alias{validate_database_schema_exists}
\title{Check if a Schema Exists in a Database}
\usage{
validate_database_schema_exists(.con, database_name, schema_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{The database name to check.}

\item{schema_name}{The schema name to check within the database.}
}
\value{
Logical \code{TRUE} if the schema exists, \code{FALSE} otherwise.
}
\description{
Checks whether a schema with the specified name exists within a given database.
}
\details{
This function queries all tables in the connection using
\code{motherduck::list_all_tables()}, filters by \code{table_catalog} (database),
and performs an exact match on the schema name.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb())
validate_database_schema_exists(con, "test_db", "main")
}

}
