% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloze.R
\name{cloze_questions}
\alias{cloze_questions}
\alias{cloze_shortanswer}
\alias{cloze_multichoice}
\alias{cloze_singlechoice}
\alias{cloze_numerical}
\alias{cloze}
\title{Generate Cloze-Type Questions for Moodle}
\usage{
cloze_shortanswer(
  options,
  weight = max(options),
  feedback = "",
  case_sensitive = FALSE
)

cloze_multichoice(
  options,
  weight = max(options),
  feedback = "",
  type = c("vertical", "horizontal"),
  shuffle = FALSE
)

cloze_singlechoice(
  options,
  weight = max(options),
  feedback = "",
  type = c("dropdown", "vertical", "horizontal"),
  shuffle = FALSE
)

cloze_numerical(answer, weight = 1, tolerance = 0, feedback = "")

cloze(x, ...)
}
\arguments{
\item{options}{A named vector of answer options. For single/multiple choice questions the \code{\link[=choices]{choices()}} helper function can help create this vector. Names correspond to answers, and values specify their weights (e.g., 100 for a correct answer or partial weights for partially correct answers). For multiple-choice and single-choice questions, this includes both correct and distractor options.}

\item{weight}{A numeric value specifying the weight for the question. Defaults to the highest weight in \code{options}.}

\item{feedback}{A character vector providing feedback for answers.}

\item{case_sensitive}{Logical. For \code{cloze_shortanswer}, whether the answer should be case-sensitive. Defaults to \code{FALSE}.}

\item{type}{A character string specifying the presentation style of the options. For \code{cloze_multichoice}, valid values are \code{"vertical"} or \code{"horizontal"}. For \code{cloze_singlechoice}, valid values are \code{"dropdown"}, \code{"vertical"}, or \code{"horizontal"}.}

\item{shuffle}{Logical. For \code{cloze_multichoice} and \code{cloze_singlechoice}, whether the answer options should be shuffled. Defaults to \code{FALSE}.}

\item{answer}{A numeric value specifying the correct numerical answer(s).}

\item{tolerance}{A numeric value specifying the acceptable range of deviation for \code{cloze_numerical} answers. Defaults to \code{0}.}

\item{x}{For \code{cloze()}, the correct answer which also determines the question type (e.g. \code{numeric} will use \code{cloze_numerical()} and \code{character} will use \code{cloze_shortanswer()} or \code{cloze_singlechoice()}/\code{cloze_multichoice()} if selectable options are given as the second argument).}

\item{...}{Additional arguments passed to other \code{cloze()} methods (such as the available options and other \verb{cloze_*()} arguments).}
}
\value{
A character string containing the Moodle-compatible XML or inline text for the specified cloze question(s).
}
\description{
These functions create cloze-type questions for Moodle quizzes, designed for use with inline R code chunks in an R Markdown document formatted with the \code{moodlequiz::moodlequiz} output format.
}
\section{Functions}{

\itemize{
\item \strong{\code{cloze_shortanswer()}}: Creates a short-answer question where the student provides a text response.
\item \strong{\code{cloze_singlechoice()}}: Generates a single-choice question where students select one correct answer from a list.
\item \strong{\code{cloze_multichoice()}}: Creates a multiple-choice question where students can select one or more correct answers.
\item \strong{\code{cloze_numerical()}}: Generates a numerical question where students input a numeric response with optional tolerance.
\item \strong{\code{cloze()}}: Automatic question types based on the class of the answers.
}
}

\examples{
# Short-answer question: Where is the best coffee?
cloze_shortanswer(
  options = c("Melbourne" = 1),
  case_sensitive = FALSE
)

# Multiple-choice question: Select all lower-case answers
cloze_multichoice(
  options = c("a" = 1, "F" = 0, "g" = 1, "V" = 0, "K" = 0),
  type = "vertical"
)

# Where is Melbourne?
cloze_singlechoice(
  choices(
    c("New South Wales", "Victoria", "Queensland", "Western Australia",
      "South Australia", "Tasmania", "Australian Capital Territory",
      "Northern Territory"),
    "Victoria"
  ),
  type = "dropdown"
)

# Numerical question: Pick a number between 1 and 10
cloze_numerical(
  answer = 5.5,
  tolerance = 4.5
)

# Automatic cloze questions
cloze(42) # Numerical
cloze("Australia") # Short answer
cloze("rep_len", c("rep", "rep.int", "rep_len", "replicate")) # Single choice
cloze(c("A", "B", "C"), LETTERS) # Multiple choice

}
