% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_refit_mmrm}
\alias{h_refit_mmrm}
\title{Refit an \code{mmrm} Model Using a New Dataset}
\usage{
h_refit_mmrm(fit, data)
}
\arguments{
\item{fit}{(\code{mmrm})\cr an \code{mmrm} object to be refit.}

\item{data}{(\verb{data frame})\cr a data frame upon which \code{fit} is to be refit.}
}
\value{
An \code{mmrm} object with the same terms as \code{fit} but based on \code{data}.
}
\description{
Extract the \code{call} \link{component} of \code{fit} and evaluate it in a new
\link[=new.env]{environment} that contains the new \code{data}.
}
\details{
This works as follows:
\enumerate{
\item A new environment is created whose parent is
\code{environment(fit$formula_parts$full_formula)}.
\item A name is generated using \code{\link[=h_generate_new_name]{h_generate_new_name()}}, and \code{data} is bound to
the new environment using this new name.
\item The \code{\link{call}} component of \code{fit} is extracted and its \code{data} argument is
changed to the new name.
\item The modified call is evaluated in the new environment.
}
}
\keyword{internal}
