% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_posterior.R
\name{sim_posterior}
\alias{sim_posterior}
\title{Simulate Posterior Odds Combining Genetic and Non-Genetic Evidence}
\usage{
sim_posterior(
  datasim,
  Prior = 0.01,
  PriorModel = c("prelim", "uniform")[1],
  eps = 0.05,
  erRs = 0.01,
  epc = error_matrix_hair(),
  erRc = error_matrix_hair(),
  MPc = 1,
  epa = 0.05,
  erRa = 0.01,
  MPa = 10,
  MPr = 2
)
}
\arguments{
\item{datasim}{Output from \code{\link{sim_lr_genetic}} containing
genetic LR simulations.}

\item{Prior}{Numeric (0-1). Prior probability for H1 (that POI is MP).
Default: 0.01.}

\item{PriorModel}{Character. How to incorporate preliminary evidence:
\itemize{
\item "prelim": Combines prior with preliminary data LRs (sex, age, color)
\item "uniform": Uses only the prior probability without preliminary LRs
}
Default: "prelim".}

\item{eps}{Numeric (0-1). Error rate for sex observation. Default: 0.05.}

\item{erRs}{Numeric (0-1). Error rate for sex in database. Default: 0.01.}

\item{epc}{Matrix. Hair color error matrix from \code{\link{error_matrix_hair}}.}

\item{erRc}{Matrix. Hair color error matrix for database.}

\item{MPc}{Integer (1-5). Missing person's hair color. Default: 1.}

\item{epa}{Numeric (0-1). Error rate for age. Default: 0.05.}

\item{erRa}{Numeric (0-1). Error rate for age in database. Default: 0.01.}

\item{MPa}{Numeric. Missing person's age. Default: 10.}

\item{MPr}{Numeric. Age range tolerance. Default: 2.}
}
\value{
A data.frame with two columns:
\itemize{
\item \code{Unrelated}: Posterior odds under H2
\item \code{Related}: Posterior odds under H1
}
}
\description{
Simulates posterior odds distributions by combining prior probabilities
with likelihood ratios from both genetic and non-genetic (preliminary
investigation) evidence. This implements a full Bayesian integration
of multiple evidence sources.
}
\details{
Posterior odds are calculated as:
\deqn{Posterior = Prior \times LR_{prelim} \times LR_{genetic}}

Where:
\itemize{
\item Prior = P(H1) / P(H2) = Prior / (1 - Prior)
\item LR_prelim = LR_sex * LR_age * LR_color
\item LR_genetic = from genetic simulation
}
}
\examples{
library(forrel)

# Setup pedigree
x <- linearPed(2)
x <- setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x <- profileSim(x, N = 1, ids = 2)

# Simulate genetic LRs
datasim <- sim_lr_genetic(x, missing = 5, numsims = 50, seed = 123)

# Compute posterior odds with preliminary evidence
post <- sim_posterior(datasim, Prior = 0.01, PriorModel = "prelim")
head(post)

# Visualize
plot_lr_distribution(post)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_lr_genetic}} for genetic simulations,
\code{\link{lr_sex}}, \code{\link{lr_age}}, \code{\link{lr_hair_color}}
for preliminary evidence LRs.
}
