% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mior.R
\name{predict.mior}
\alias{predict.mior}
\title{Predict method for \code{mior} object}
\usage{
\method{predict}{mior}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("bag", "instance"),
  new_bags = "bag_name",
  ...
)
}
\arguments{
\item{object}{An object of class \code{mior}}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values with threshold of 0 as
-1 or +1.  If \code{'raw'}, return the raw predicted scores.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column \code{.pred_class}.  If \code{type = 'raw'}, the tibble will have
a column \code{.pred}.
}
\description{
Predict method for \code{mior} object
}
\details{
When the object was fitted using the \code{formula} method, then the parameters
\code{new_bags} and \code{new_instances} are not necessary, as long as the names match
the original function call.
}
\examples{
if (require(gurobi)) {
  set.seed(8)
  # make some data
  n <- 15
  X <- rbind(
    mvtnorm::rmvnorm(n/3, mean = c(4, -2, 0)),
    mvtnorm::rmvnorm(n/3, mean = c(0, 0, 0)),
    mvtnorm::rmvnorm(n/3, mean = c(-2, 1, 0))
  )
  score <- X \%*\% c(2, -1, 0)
  y <- as.numeric(cut(score, c(-Inf, quantile(score, probs = 1:2 / 3), Inf)))
  bags <- 1:length(y)

  # add in points outside boundaries
  X <- rbind(
    X,
    mvtnorm::rmvnorm(n, mean = c(6, -3, 0)),
    mvtnorm::rmvnorm(n, mean = c(-6, 3, 0))
  )
  y <- c(y, rep(-1, 2*n))
  bags <- rep(bags, 3)
  repr <- c(rep(1, n), rep(0, 2*n))

  y_bag <- classify_bags(y, bags, condense = FALSE)

  mdl1 <- mior(X, y_bag, bags)
  # summarize predictions at the bag layer
  library(dplyr)
  df1 <- bind_cols(y = y_bag, bags = bags, as.data.frame(X))
  df1 \%>\%
    bind_cols(predict(mdl1, df1, new_bags = bags, type = "class")) \%>\%
    bind_cols(predict(mdl1, df1, new_bags = bags, type = "raw")) \%>\%
    distinct(y, bags, .pred_class, .pred)
}

}
\seealso{
\code{\link[=mior]{mior()}} for fitting the \code{mior} object.
}
\author{
Sean Kent
}
