% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaquant.R
\name{est.r.study.level}
\alias{est.r.study.level}
\title{Estimating Variances of Squared IQR Ratio and its Natural Logarithm}
\usage{
est.r.study.level(
   min.g1, 
   q1.g1, 
   med.g1, 
   q3.g1, 
   max.g1, 
   n.g1, 
   min.g2, 
   q1.g2, 
   med.g2, 
   q3.g2, 
   max.g2, 
   n.g2,
   method, 
   opt = TRUE, 
   single.family = FALSE, 
   qe.fit.control.g1 = list(), 
   qe.fit.control.g2 = list()
 )
}
\arguments{
\item{min.g1}{numeric value representing the sample minimum (of group one for two-group studies).}

\item{q1.g1}{numeric value representing the first quartile of the sample (of group one for two-group studies).}

\item{med.g1}{numeric value representing the median of the sample (of group one for two-group studies).}

\item{q3.g1}{numeric value representing the third quartile of the sample (of group one for two-group studies).}

\item{max.g1}{numeric value representing the sample maximum (of group one for two-group studies).}

\item{n.g1}{numeric value specifying the sample size (of group one for two-group studies).}

\item{min.g2}{numeric value representing the sample minimum of group two for two-group studies.}

\item{q1.g2}{numeric value representing the first quartile of the sample of group two for two-group studies.}

\item{med.g2}{numeric value representing the median of the sample of group two for two-group studies.}

\item{q3.g2}{numeric value representing the third quartile of the sample of group two for two-group studies.}

\item{max.g2}{numeric value representing the sample maximum of group two for two-group studies.}

\item{n.g2}{numeric value specifying the sample size of group two for two-group studies.}

\item{method}{character string specifying the density-based approach used to
estimate variances of squared IQR ratio and its natural logarithm. Options:
\describe{
\item{\code{'gld'}}{The default option. Estimation method proposed by
De Livera et al. (2024) using the generalised lambda distribution (GLD).}
\item{\code{'qe'}}{Quantile Matching Estimation method proposed by McGrath
et al. (2020).}
}}

\item{opt}{logical; whether to apply the optimisation step of the
\code{"gld"} method when estimating its parameters. Default is \code{TRUE}.}

\item{single.family}{logical; for two-group studies using the \code{"qe"}
method, whether to assume the same parametric family of distributions for
both groups. Default is \code{FALSE}.
See \code{\link[metamedian:qe.study.level]{qe.study.level}}}

\item{qe.fit.control.g1}{optional list of control parameters for
\code{\link[estmeansd:qe.fit]{qe.fit}} (of group one for two-group studies).}

\item{qe.fit.control.g2}{optional list of control parameters for
\code{\link[estmeansd:qe.fit]{qe.fit}} of group two for two-group studies.}
}
\value{
A list containing following components:
\itemize{
\item \code{effect.size}: numeric value of the effect size of the study (ratio of squared IQRs).
\item \code{estvar}: estimated variance of the effect size (ratio of squared IQRs).
\item \code{effect.size.log}: numeric value of log ratio of squared IQRs.
\item \code{estvar.log}: estimated variance of log ratio of squared IQRs.
\item \code{number.of.groups}: integer indicating the number of groups in the
input study data.
}
}
\description{
This function estimates the variances of squared IQR ratio and its logarithm
for two-group studies, from studies that report five-number summaries
(minimum, first quartile, median, third quartile, maximum) and sample sizes,
using density-based approaches.

The \code{est.r.study.level} function currently supports two density-based frameworks:
(1) a Generalized Lambda Distribution (GLD) fitted via percentile matching,
following De Livera et al. (2024); and (2) an extension of the Quantile Estimation
(QE) method of McGrath et al. (2020) to additional quantiles and functions of
quantiles.

The function estimates the asymptotic variances of the following effect sizes:
\itemize{
\item Ratio of squared interquartile ranges (IQRs) between two groups:
\eqn{r = (q_{3g1}-q_{1g1})^2 / (q_{3g2}-q_{1g2})^2}.
\item Log ratio of squared IQRs between two groups:
\eqn{log(r)}.

}

Portions of this implementation are adapted from
\code{\link[metamedian:qe.study.level]{qe.study.level}}
for the QE method, and have been extended to support functions of quantiles
beyond the median.
}
\examples{
#Generate 5-number summary data (group one)
set.seed(123)
n1 <- 100
x1 <- stats::rlnorm(n1, 4, 0.3)
quants1 <- c(min(x1), stats::quantile(x1, probs = c(0.25, 0.5, 0.75)), max(x1))

#Generate 5-number summary data (group two)
set.seed(123) 
n2 <- 120
x2 <- stats::rlnorm(n2, 3, 0.5)
quants2 <- c(min(x2), stats::quantile(x2, probs = c(0.25, 0.5, 0.75)), max(x2))

#Estimate variance of the squared IQR ratio and its natural logarithm (for two groups)
est.r.study.level(min.g1 = quants1[1], q1.g1 = quants1[2], med.g1 = quants1[3], 
                  q3.g1 = quants1[4], max.g1 = quants1[5], n.g1=n1, 
                  min.g2 = quants2[1], q1.g2 = quants2[2], med.g2 = quants2[3], 
                  q3.g2 = quants2[4],  max.g2 = quants2[5], n.g2=n2, 
                  method = "gld")
                 
                 
}
\references{
De Livera, A. M., Prendergast, L., & Kumaranathunga, U. (2024). A novel
density-based approach for estimating unknown means, distribution visualisations and meta-analyses
of quantiles. \emph{arXiv preprint arXiv:2411.10971}. \url{https://arxiv.org/abs/2411.10971}.

King, R., Dean, B., Klinke, S., & van Staden, P. (2025). gld: Estimation
and use of the Generalised (Tukey) Lambda Distribution (R package Version 2.6.7). Comprehensive R
Archive Network (CRAN). https://doi.org/10.32614/CRAN.package.gld. \url{https://CRAN.R-project.org/package=gld}.

McGrath, S., Sohn, H., Steele, R., & Benedetti, A. (2020). Meta‐analysis of
the difference of medians. \emph{Biometrical Journal}, 62(1), 69-98.

McGrath, S., Zhao, X., Ozturk, O., Katzenschlager, S., Steele, R., & Benedetti, A. (2024).
Metamedian: an R package for meta‐analyzing studies reporting medians. \emph{Research Synthesis Methods}, 15(2), 332-346.
}
\seealso{
\code{\link[=est.q.study.level]{est.q.study.level()}}
}
