% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_dexpm.R
\name{mc_expm}
\alias{mc_expm}
\title{Exponential-matrix covariance link function}
\usage{
mc_expm(U, n = dim(U)[1], sparse = FALSE, inverse = FALSE)
}
\arguments{
\item{U}{A matrix.}

\item{n}{A number specifing the dimension of the matrix U. Default
\code{n = dim(U)[1]}.}

\item{sparse}{Logical defining the class of the output matrix. If
\code{sparse = TRUE} the output class will be 'dgCMatrix' if
\code{sparse = FALSE} the class will be 'dgMatrix'.}

\item{inverse}{Logical defining if the inverse will be computed or
not.}
}
\value{
A list containing \eqn{\Omega = expm(U)}, its inverse (if
  \code{inverse = TRUE}), and auxiliary matrices used to compute the
  derivatives. The returned object is intended for internal use only.
}
\description{
Given a matrix \code{U} the function \code{mc_expm}
    returns the exponential-matrix \eqn{expm(U)} and some auxiliares
    matrices to compute its derivatives. This function is based on
    the eigen-value decomposition it means that it is very slow.
}
\seealso{
\code{\link[Matrix]{expm}}, \code{\link[base]{eigen}},
    \code{link[mcglm]{mc_dexp_gold}}.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
