% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_compute_rho.R
\name{mc_compute_rho}
\alias{mc_compute_rho}
\title{Autocorrelation Estimates}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_compute_rho(object, level = 0.975)
}
\arguments{
\item{object}{an object or a list of objects representing a model
of \code{mcglm} class.}

\item{level}{the confidence level required.}
}
\value{
Returns a data frame with parameter estimate, standard error and
confidential interval for the spatial autocorrelation parameter. It is used
in the case of spatial models using the \code{mc_car} specification.
}
\description{
Compute autocorrelation estimates based on a fitted model
using the \code{mc_car} structure. The \code{mcglm} approach fits
models using a linear covariance structure, but in general in this
parametrization for spatial models the parameters have no simple
interpretation in terms of spatial autocorrelation.
The function \code{mc_compute_rho} computes the autocorrelation
based on a fitted model.
}
\seealso{
\code{mc_car} and \code{mc_conditional_test}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
