% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-grid-BDN.R
\encoding{UTF-8}
\name{esp_get_grid_BDN}
\alias{esp_get_grid_BDN}
\alias{esp_get_grid_BDN_ccaa}
\title{National geographic grids from BDN (Nature Data Bank)}
\source{
Data sourced from the Banco de Datos de la Naturaleza (BDN) via a custom
CDN. See the repository structure:
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/MTN}

For more information about BDN grids and other resources, visit:
\url{https://www.miteco.gob.es/es/biodiversidad/servicios/banco-datos-naturaleza/informacion-disponible/bdn-cart-aux-descargas-ccaa.html}.
}
\usage{
esp_get_grid_BDN(
  resolution = c(10, 5),
  type = c("main", "canary"),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

esp_get_grid_BDN_ccaa(
  ccaa,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{numeric. Resolution of the grid in kms. Must be one of:
\itemize{
\item \code{5}: 5x5 kilometer cells
\item \code{10}: 10x10 kilometer cells (default)
}}

\item{type}{character. The geographic scope of the grid:
\itemize{
\item \code{"main"}: Mainland Spain (default)
\item \code{"canary"}: Canary Islands
}}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{ccaa}{character string. A vector of names and/or codes for Autonomous
Communities. See \strong{Details} on \code{\link[=esp_get_ccaa]{esp_get_ccaa()}} for accepted formats.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{POLYGON} object with the geographic grids of
Spain as provided by the Banco de Datos de la Naturaleza (Nature Data Bank),
under the Ministry of Environment (MITECO).

This dataset provides:
\itemize{
\item \code{\link[=esp_get_grid_BDN]{esp_get_grid_BDN()}} extracts country-wide regular grids with resolutions
of 5x5 or 10x10 kilometers (mainland Spain or Canary Islands).
\item \code{\link[=esp_get_grid_BDN_ccaa]{esp_get_grid_BDN_ccaa()}} extracts 1x1 kilometer resolution grids for
individual Autonomous Communities.
}

These grids are useful for biodiversity analysis, environmental monitoring,
and spatial statistical applications.

\code{esp_get_grid_BDN_ccaa()} provides higher-resolution 1x1 kilometer grids
for specific Autonomous Communities, useful for regional analysis with
finer spatial detail.
}
\details{
The BDN provides standardized geographic grids for Spain that follow the
Nature Data Bank's specifications. The data is maintained via a custom CDN
and is regularly updated.
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# Load a 10x10 km grid for mainland Spain
grid <- esp_get_grid_BDN(resolution = 10, type = "main")

# Visualize the grid
library(ggplot2)

ggplot(grid) +
  geom_sf(fill = NA, color = "steelblue") +
  theme_light() +
  labs(title = "BDN Geographic Grid: 10x10 km Spain")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=esp_get_ccaa]{esp_get_ccaa()}}

Other geographical grids:
\code{\link{esp_get_grid_ESDAC}()},
\code{\link{esp_get_grid_MTN}()}
}
\concept{grids}
