% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlh_outsample_row_indices.R
\name{mlh_outsample_row_indices}
\alias{mlh_outsample_row_indices}
\title{mlh_outsample_row_indices}
\usage{
mlh_outsample_row_indices(fold_list, dataset_nrows, type = NULL)
}
\arguments{
\item{fold_list}{A list of integer vectors that describe the row indices
of cross-validation folds. The list must be named.}

\item{dataset_nrows}{An integer. The number of rows in the dataset
dataset. This parameter is required in order to compute the out-of-sample
row indices.}

\item{type}{A character. To be used if the out-of-sample row indices need to
be formatted in a special manner (default: \code{NULL}). Currently, the only
allowed value is \code{type = "glmnet"} in order to format the row indices as
required by \code{glmnet::cv.glmnet}'s argument \code{foldid}.}
}
\value{
If \code{type = NULL}, returns a list of same length as \code{fold_list} with
each item containing a vector of out-of-sample row indices. If
\code{type = "glmnet"}, a data.table is returned with two columns and each row
representing one observation of the dataset that is assigned to a specific
test fold. The column "fold_id" should be passed further on to the argument
\code{foldid} of \code{glmnet::cv.glmnet}.
}
\description{
Machine learning helper function to convert a vector of (in-
sample) row indices of a fold into out-of-sample row indices.
}
\examples{
fold_list <- list(
  "Fold1" = setdiff(seq_len(100), 1:33),
  "Fold2" = setdiff(seq_len(100),66:100),
  "Fold3" = setdiff(seq_len(100),34:65)
)
mlh_outsample_row_indices(fold_list, 100)
mlh_outsample_row_indices(fold_list, 100, "glmnet")
}
