% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{narayan}
\alias{narayan}
\title{NARAYAN test}
\usage{
narayan(model, case = 3, signif_level = "auto")
}
\arguments{
\item{model}{The kardl obejct}

\item{case}{Numeric or character. Specifies the case of the test to be used in the function.
Acceptable values are 1, 2, 3, 4, 5, and "auto". If "auto" is chosen, the function determines the case automatically based on the model's characteristics. Invalid values will result in an error.
\itemize{
\item \code{1}: No intercept and no trend. This case is not supported by the Narayan test.
\item \code{2}: Restricted intercept and no trend.
\item \code{3}: Unrestricted intercept and no trend.
\item \code{4}: Unrestricted intercept and restricted trend.
\item \code{5}: Unrestricted intercept and unrestricted trend.
}}

\item{signif_level}{Character or numeric. Specifies the significance level to be used in the function.
Acceptable values are "auto", "0.10", "0.1", "0.05", "0.025", and "0.01".
If a numeric value is provided, it will be converted to a character string.
If "auto" is chosen, the function determines the significance level automatically.
Invalid values will result in an error.}
}
\value{
A list with class "kardl" containing the following components:
\itemize{
\item \code{type:} The type of the test, which is "cointegration".
\item \code{case:} The case of the test, which is a numeric value (1, 2, 3, 4, or 5).
\item \code{statistic:} The calculated F-statistic for the test.
\item \code{k:} The number of long-run variables in the model.
\item \code{Cont:} The conclusion of the test, indicating whether cointegration is found, inconclusive, or not found.
\item \code{BoundNum:} A numeric value indicating the result of the test: 1 for cointegration, 0 for inconclusive, and -1 for no cointegration.
\item \code{siglvl:} The significance level used in the test, which can be "auto", "0.10", "0.1", "0.05", "0.025", or "0.01".
\item \code{criticalValues:} A numeric vector containing the critical values for the test based on the specified case and significance level.
\item \code{parameter:} A character vector containing the names of the long-run parameters in the model.
\item \code{FH0:} The null hypothesis of the test, which is a character string describing the hypothesis being tested.
\item \code{Fmodel:} The detailed F test results, including the F-statistic, p-value, degrees of freedom, and residual degrees of freedom.
\item \code{warnings:} A character vector containing any warnings generated during the test, such as issues with the model specification or data length.
\item \code{method:} The method used for the test.
}
}
\description{
This function performs the Narayan test, which is designed to assess cointegration using critical values specifically tailored for small sample sizes. Unlike traditional cointegration tests that may rely on asymptotic distributions, the Narayan test adjusts for the limitations of small samples, providing more accurate results in such contexts. This makes the test particularly useful for studies with fewer observations, as it accounts for sample size constraints when determining the presence of a long-term equilibrium relationship between variables.
}
\section{Hypothesis testing}{

The null hypothesis (H0) of the F Bound test is that there is no cointegration among the variables in the model. In other words, it tests whether the long-term relationship between the variables is statistically significant. If the calculated F-statistic exceeds the upper critical value, we reject the null hypothesis and conclude that there is cointegration. Conversely, if the F-statistic falls below the lower critical value, we fail to reject the null hypothesis, indicating no evidence of cointegration. If the F-statistic lies between the two critical values, the result is inconclusive.


 \deqn{
  \Delta {y}_t =  \psi  + \varphi t  + \eta _0   {y}_{t-1}  + \sum_{i=1}^{k} {  \eta _i   {x}_{i,t-1} }  +   \sum_{j=1}^{p} { \gamma_{j}  \Delta {y}_{t-j} }+ \sum_{i=1}^{k} {\sum_{j=0}^{q_i} { \beta_{ij}   \Delta {x}_{i,t-j} } }+ e_t
}

\describe{
  \item{Cases 1, 3, 5:}{
     \deqn{\mathbf{H_{0}:} \eta_0  = \eta_1  = \dots = \eta_k  = 0}
     \deqn{\mathbf{H_{1}:} \eta_{0} \neq \eta_{1} \neq \dots \neq \eta_{k} \neq 0}
  }
  \item{Case 2:}{
     \deqn{\mathbf{H_{0}:} \eta_0  = \eta_1  = \dots = \eta_k =  \psi  = 0}
     \deqn{\mathbf{H_{1}:} \eta_{0} \neq \eta_{1} \neq \dots \neq \eta_{k}  \neq \psi \neq 0}
  }

  \item{Case 4:}{
     \deqn{\mathbf{H_{0}:} \eta_0  = \eta_1  = \dots = \eta_k = \varphi = 0}
     \deqn{\mathbf{H_{1}:} \eta_{0} \neq \eta_{1} \neq \dots \neq \eta_{k}  \neq \varphi \neq 0}
      }
  }
}

\examples{

kardl_model<-kardl(imf_example_data,
                   CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                   mode=c(1,2,3,0))
A<-narayan(kardl_model)
A
cat(paste0("The F statistics=",A$statistic," where k=",A$k,"."))
cat(paste0("\nWe found '",A$Cont, "' at ",A$siglvl,"."))
cat(paste0("\nThe proboblity is = ",sprintf("\%.10f",A$Fmodel[["Pr(>F)"]][2])))

# Utilising magrittr:

library(magrittr)
imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                   mode=c(1,2,3,0)) \%>\% narayan()


# Getting details of the test.
mySummary<-summary(A)
mySummary

# Utilising magrittr:
imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                   mode=c(1,2,3,0)) \%>\% narayan()  \%>\% summary()


# Critical Values are
A$criticalValues
# The null hypothesis :
A

# getting H0
mySummary$H0

# Detailed F test
A$Fmodel
}
\references{
Narayan, P. K. (2005). The saving and investment nexus for China: evidence from cointegration tests. Applied economics, 37(17), 1979-1990.
}
\seealso{
\code{\link{pssf}}  \code{\link{psst}}  \code{\link{banerjee}}  \code{\link{recmt}}
}
