% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runVocabChecks.R
\name{runVocabChecks}
\alias{runVocabChecks}
\title{Runs vocabulary checks on a dataset}
\usage{
runVocabChecks(filename, datasetverID, recordType)
}
\arguments{
\item{filename}{the filename of the file to check}

\item{datasetverID}{the dataset ID}

\item{recordType}{string name of the record type}
}
\value{
The list of vocabulary errors. Every line that failed is
        reported for each field.
}
\description{
Check vocabularies in a data set against the ICES DATSU data
submission utility, the user must supply a dataset version and
record type.
}
\examples{
\dontrun{
filename <- system.file("test_files/vms_test.csv", package = "icesDatsuQC")
vc <- runVocabChecks(filename, 145, "VE")
if (length(vc) > 0) {
  library(icesDatsu)
  data <-
    read.csv(
      filename,
      header = FALSE,
      col.names = getDataFieldsDescription(145, "VE")$fieldcode
  )
  # some invalid entries
  data[vc[[1]], names(vc)[1]]
}
}
}
