% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.h.r, R/sample.zi.r
\name{sample.h}
\alias{sample.h}
\alias{sample.zi}
\title{Generate random deviates from zero-inflated or hurdle models}
\usage{
sample.h(N, phi, distri = "poisson", lambda = NA, r = NA, p = NA,
  alpha1 = NA, alpha2 = NA, n = NA)

sample.zi(N, phi, distri = "poisson", lambda = NA, r = NA, p = NA,
  alpha1 = NA, alpha2 = NA, n = NA)
}
\arguments{
\item{N}{The sample size. Should be a positive number. If it is not an integer, N will be automatically rounded up to the
smallest integer that no less than N.}

\item{phi}{The structural parameter \eqn{\phi}, should be a positive value within (0,1).}

\item{distri}{The corresponding standard distribution. Can be one of \{'poisson','nb','bb', 'bnb'\}, which corresponds to Poisson,
negative binomial, beta binomial and beta negative binomial distributions respectively.}

\item{lambda}{A value for the parameter of Poisson distribution. Should be a positive number.}

\item{r}{the number of success before which m failures are observed, where m is a random variable from negative binomial
or beta negative binomial distribution. Must be a positive number. If it is not an integer, r will be automatically rounded up to the
smallest integer that no less than r.}

\item{p}{The probability of success, should be a positive value within (0,1).}

\item{alpha1}{The first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{The second shape parameter of beta distribution. Should be a positive number.}

\item{n}{The number of trials. Must be a positive number. If it is not an integer, n will be automatically rounded up to the
smallest integer that no less than n.}
}
\value{
A vector of length \eqn{N} containing non-negative integers from the zero-inflated or hurdle version of distribution
determined by \eqn{distri}.
}
\description{
Generate random deviates from zero-inflated or hurdle Poisson, negative binomial, beta binomial and beta negative binomial
models.
}
\details{
By setting \code{distri=poisson}, \code{sample.h} and \code{sample.zi} simulates \code{N} random deviates from hurdle and
zero-inflated Poisson distribution, respectively, and so on forth. For arguments with length larger than 1, only the first
element will be used.

Arguments \code{r} and \code{p} are for the use of zero-inflated and hurdle negative binomial distributions. \code{alpha1},
\code{alpha2} and \code{n} are for
zero-inflated and hurdle beta binomial distributions. \code{r}, \code{alpha1} and \code{alpha2} are used in zero-inflated and hurdle beta
negative binomial distributions.

The procedure of generating random deviates follows the work of Aldirawi et al. (2019). The algorithm calls functions for
standard distributions to simulate the non-zero samples. Random deviates from standard Poisson and negative binomial
distributions can be generated by basic R function \code{rpois} and \code{rnbinom}. Functions rbbinom and rbnbinom are
available for standard beta binomial and beta negative binomial distributions in R package \code{extraDistr}.
}
\section{Reference}{

\itemize{
 \item{H. Aldirawi, J. Yang, A. A. Metwally, Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data,
 accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI) (2019).}
 \item{T. Wolodzko, extraDistr: Additional Univariate and Multivariate Distributions, R package version 1.8.11 (2019),
  https://CRAN.R-project.org/package=extraDistr.}
}
}

\examples{
t1=sample.h(N=2000,phi=0.2,distri='Poisson',lambda=5)  ##hurdle poisson random values
t2=sample.h(N=2000,phi=0.2,distri='nb',r=10,p=0.6)   ##hurdle negative binomial
t3=sample.h(N=2000,phi=0.2,distri='bb',alpha1=8,alpha2=9,n=10)   ##hurdle beta binomial
##hurdle beta negative binomial.
t4=sample.h(N=2000,phi=0.2,distri='bnb',r=10,alpha1=8,alpha2=9)

t1=sample.zi(N=2000,phi=0.2,distri='Poisson',lambda=5)  ##zero-inflated poisson random values
t2=sample.zi(N=2000,phi=0.2,distri='nb',r=10,p=0.6)   ##zero-inflated negative binomial
t3=sample.zi(N=2000,phi=0.2,distri='bb',alpha1=8,alpha2=9,n=10)   ##zero-inflated beta binomial
##zero-inflated beta negative binomial
t4=sample.zi(N=2000,phi=0.2,distri='bnb',r=10,alpha1=8,alpha2=9)
}
