% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb.mle.r, R/bnb.mle.r, R/nb.mle.r,
%   R/poisson.mle.r
\name{bb.mle}
\alias{bb.mle}
\alias{bnb.mle}
\alias{nb.mle}
\alias{poisson.mle}
\title{Maximum likelihood estimate for beta binomial distributions}
\usage{
bb.mle(x, n, alpha1, alpha2, lowerbound = 0.01, upperbound = 10000)

bnb.mle(x, r, alpha1, alpha2, lowerbound = 0.01, upperbound = 10000)

nb.mle(x, r, p, lowerbound = 0.01, upperbound = 10000)

poisson.mle(x)
}
\arguments{
\item{x}{A vector of count data. Should be non-negative integers.}

\item{n}{An initial value of the number of trials. Must be a positive number, but not required to be an integer.}

\item{alpha1}{An initial value for the first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{An initial value for the second shape parameter of beta distribution. Should be a positive number.}

\item{lowerbound}{A lower searching bound used in the optimization of likelihood function. Should be a small positive number.
The default is 1e-2.}

\item{upperbound}{An upper searching bound used in the optimization of likelihood function. Should be a large positive number.
The default is 1e4.}

\item{r}{An initial value of the number of success before which m failures are observed, where m is the element of x.
Must be a positive number, but not required to be an integer.}

\item{p}{An initial value of the probability of success, should be a positive value within (0,1).}
}
\value{
A row vector containing the maximum likelihood estimate of unknown parameters and the corresponding value of log likelihood.

With \eqn{bb.mle}, the following values are returned:
\itemize{
  \item{n: the maximum likelihood estimate of n.}
  \item{alpha1: the maximum likelihood estimate of alpha1.}
  \item{alpha2: the maximum likelihood estimate of alpha2.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \eqn{bnb.mle}, the following values are returned:
\itemize{
  \item{r: the maximum likelihood estimate of r.}
  \item{alpha1: the maximum likelihood estimate of alpha1.}
  \item{alpha2: the maximum likelihood estimate of alpha2.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \eqn{nb.mle}, the following values are returned:
\itemize{
  \item{r: the maximum likelihood estimate of r.}
  \item{p: the maximum likelihood estimate of p.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \eqn{poisson.mle}, the following values are returned:
\itemize{
  \item{lambda: the maximum likelihood estimate of lambda.}
  \item{loglik: the value of log likelihood with maximum likelihood estimate plugged-in.}
}
}
\description{
calculate maximum likelihood estimate and the corresponding log likelihood value for beta binomial,
beta negative binomial, negative binomial and Poisson distributions.
}
\details{
\code{bb.mle}, \code{bnb.mle}, \code{nb.mle} and \code{poisson.mle} calculate the maximum likelihood estimate of beta binomial,
beta negative binomial, negative binomial and Poisson distributions, respectively.

Please NOTE that the arguments in the four functions are NOT CHECKED AT ALL! The user must be aware of their inputs to avoid
getting suspicious results.

Suppose that \eqn{X} is a random count variable that only takes non-negative values. If \eqn{p} has a prior distribution
\eqn{beta(alpha1,alpha2)} and \eqn{X} follows a binomial distribution \eqn{b(n,p)}, then \eqn{X} follows the beta binomial
distribution with

\eqn{P(X=k)=C(n,k)Beta(k+alpha1,n-k+alpha2)/Beta(alpha1,alpha2)},

where \eqn{C(,)} is the combination function, \eqn{Beta(,)} is the beta function and \eqn{beta(,)} stands for the beta distribution.

If \eqn{X} stands for the number of failures observed before the \eqn{r}th success, the probability of \eqn{X} taking the
value \eqn{k} under the negative binomial distribution equals

\eqn{P(X=k)=C(k+r-1,k)p^r(1-p)^k},

As in beta binomial distribution, assume the prior distribution of \eqn{p} is \eqn{beta(alpha1,alpha2)}. \eqn{X} follows
a beta negative binomial distribution if \eqn{X} follows a negative binomial distribution with parameters \eqn{r} and \eqn{p}.
The probability density function of a beta negative binomial distribution is defined as:

\eqn{P(X=k)=\Gamma(r+k)Beta(r+alpha1,k+alpha2)/Beta(alpha1,alpha2)/\Gamma(r)/k!},

where \eqn{\Gamma} represents the Gamma function.

With the only parameter \eqn{lambda}, the probability density function of a Poisson distribution is

\eqn{P(X=k)=lambda^k exp(-lambda)/k!}

The maximum likelihood estimate of all four distributions can be derived by minimizing the corresponding negative log likelihood
function. It is easy to deduce the sample estimate of \eqn{lambda} which is equal to the sample mean. However, it is not so
straightforward to solve the optimization problems of the other three distributions. Thus, we adopt the optimization
algorithm "L-BFGS-B" by calling R basic
function \code{optim}. Lower and upper bounds on the unknown parameters are required for the algorithm "L-BFGS-B", which are
determined by the arguments \code{lowerbound} and \code{upperbound}. But note that for the estimate of \eqn{p}, the upper bound
for searching is essentially \code{1-lowerbound}.
}
\section{Reference}{

\itemize{
 \item{H. Aldirawi, J. Yang, A. A. Metwally (2019). Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data,
 accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI).}
}
}

\examples{
x=extraDistr::rbbinom(2000,12,2,4)
bb.mle(x,3,1,1)
x=extraDistr::rbnbinom(2000,8,3,5)
bnb.mle(x, 3.3, 1, 1)
x=stats::rnbinom(2000,size=5,prob=0.3)
nb.mle(x, 7, 0.5)
x=stats::rpois(2000,7)
poisson.mle(x)
}
