% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-valid-url.R
\name{is_valid_url}
\alias{is_valid_url}
\title{Check if a URL is valid}
\usage{
is_valid_url(url)
}
\arguments{
\item{url}{A character string representing the URL to be checked.}
}
\value{
A logical value: \code{TRUE} if the URL is valid, \code{FALSE} otherwise.
}
\description{
This function validates a URL by checking the presence of a scheme and a
hostname in the parsed URL.
}
\details{
The function uses the \code{httr2::url_parse} function to parse the URL
and checks if the parsed URL contains a scheme and a hostname. If either
is missing, the URL is considered invalid.
}
\examples{
is_valid_url("https://www.example.com") # TRUE
is_valid_url("not_a_url") # FALSE

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
