% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.transform_frame}
\alias{h2o.transform_frame}
\title{Use GRLM to transform a frame.}
\usage{
h2o.transform_frame(model, fr)
}
\arguments{
\item{model}{H2O GRLM model}

\item{fr}{H2OFrame}
}
\value{
Returns a transformed frame
}
\description{
Use GRLM to transform a frame.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the USArrests dataset into H2O:
arrests <- h2o.importFile(
  "https://s3.amazonaws.com/h2o-public-test-data/smalldata/pca_test/USArrests.csv"
)

# Split the dataset into a train and valid set:
arrests_splits <- h2o.splitFrame(data = arrests, ratios = 0.8, seed = 1234)
train <- arrests_splits[[1]]
valid <- arrests_splits[[2]]

# Build and train the model:
glrm_model = h2o.glrm(training_frame = train,
                      k = 4,
                      loss = "Quadratic",
                      gamma_x = 0.5,
                      gamma_y = 0.5,
                      max_iterations = 700,
                      recover_svd = TRUE,
                      init = "SVD",
                      transform = "STANDARDIZE")

# Eval performance:
arrests_perf <- h2o.performance(glrm_model)

# Generate predictions on a validation set (if necessary):
arrests_pred <- h2o.predict(glrm_model, newdata = valid)

# Transform the data using the dataset "valid" to retrieve the new coefficients:
glrm_transform <- h2o.transform_frame(glrm_model, valid)
}
}
