% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{h2o.parseRaw}
\alias{h2o.parseRaw}
\title{H2O Data Parsing}
\usage{
h2o.parseRaw(
  data,
  pattern = "",
  destination_frame = "",
  header = NA,
  sep = "",
  col.names = NULL,
  col.types = NULL,
  na.strings = NULL,
  blocking = FALSE,
  parse_type = NULL,
  chunk_size = NULL,
  decrypt_tool = NULL,
  skipped_columns = NULL,
  force_col_types = FALSE,
  custom_non_data_line_markers = NULL,
  partition_by = NULL,
  quotechar = NULL,
  escapechar = ""
)
}
\arguments{
\item{data}{An H2OFrame object to be parsed.}

\item{pattern}{(Optional) Character string containing a regular expression to match file(s) in
the folder.}

\item{destination_frame}{(Optional) The hex key assigned to the parsed file.}

\item{header}{(Optional) A logical value indicating whether the first row is
the column header. If missing, H2O will automatically try to detect
the presence of a header.}

\item{sep}{(Optional) The field separator character. Values on each line of
the file are separated by this character. If \code{sep = ""}, the
parser will automatically detect the separator.}

\item{col.names}{(Optional) An H2OFrame object containing a
single delimited line with the column names for the file.  If skipped_columns are specified,
only list column names of columns that are not skipped.}

\item{col.types}{(Optional) A vector specifying the types to attempt to force
over columns.  If skipped_columns are specified, only list column types of columns that are not skipped.}

\item{na.strings}{(Optional) H2O will interpret these strings as missing.}

\item{blocking}{(Optional) Tell H2O parse call to block synchronously instead
of polling.  This can be faster for small datasets but loses the
progress bar.}

\item{parse_type}{(Optional) Specify which parser type H2O will use.
Valid types are "ARFF", "XLS", "CSV", "SVMLight"}

\item{chunk_size}{size of chunk of (input) data in bytes}

\item{decrypt_tool}{(Optional) Specify a Decryption Tool (key-reference
acquired by calling \link{h2o.decryptionSetup}.}

\item{skipped_columns}{a list of column indices to be excluded from parsing}

\item{force_col_types}{(Optional) if true will force parser to return the exact column types specified in 
column_types.  For parquet, if column_types is not specified, the parquet schema will be used to determine 
the actual column type.}

\item{custom_non_data_line_markers}{(Optional) If a line in imported file starts with any character in given string it will NOT be imported. Empty string means all lines are imported, NULL means that default behaviour for given format will be used}

\item{partition_by}{(Optional) Names of the columns the persisted dataset has been partitioned by.}

\item{quotechar}{A hint for the parser which character to expect as quoting character. None (default) means autodetection.}

\item{escapechar}{(Optional) One ASCII character used to escape other characters.}
}
\description{
The second phase in the data ingestion step.
}
\details{
Parse the Raw Data produced by the import phase.
}
\seealso{
\link{h2o.importFile}, \link{h2o.parseSetup}
}
