% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.atc}
\alias{h2o.atc}
\title{Retrieve Average Treatment Effect on the Control}
\usage{
h2o.atc(object, train = FALSE, valid = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OBinomialUpliftMetrics} or}

\item{train}{Retrieve the training ATC value}

\item{valid}{Retrieve the validation ATC value}
}
\description{
Retrieves ATC from an \linkS4class{H2OBinomialUpliftMetrics}.
If "train" and "valid" parameters are FALSE (default), then the training ATC is returned. If more
than one parameter is set to TRUE, then a named vector of ATC values are returned, where the names are "train", "valid".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/uplift/criteo_uplift_13k.csv"
train <- h2o.importFile(f)
train$treatment <- as.factor(train$treatment)
train$conversion <- as.factor(train$conversion)

model <- h2o.upliftRandomForest(training_frame=train, x=sprintf("f\%s",seq(0:10)), y="conversion",
                                ntrees=10, max_depth=5, treatment_column="treatment",
                                auuc_type="AUTO")
perf <- h2o.performance(model, train=TRUE) 
h2o.atc(perf)
}
}
