% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows_argument.R
\name{rows_argument}
\alias{rows_argument}
\title{\code{rows} argument}
\description{
The rows argument accepts a predicate expression that is used to specify
rows to apply formatting. The expression must evaluate to a logical when
evaluated in \code{x$table_body}. For example, to apply formatting to the age rows
pass \code{rows = variable == "age"}. A vector of row numbers is NOT acceptable.

The \code{x$table_body} contains columns that are hidden in the final print of
a table that are often useful for defining these expressions; print the table
to view all column available.

A couple of things to note when using the \code{rows} argument.
\enumerate{
\item You can use saved objects to create the predicate argument, e.g.
\code{rows = variable == letters[1]}.
\item The saved object cannot share a name with a column in \code{x$table_body}.
The reason for this is that in \code{tbl_merge()} the columns are renamed,
and the renaming process cannot disambiguate the \code{variable} column from
an external object named \code{variable} in the following expression
\code{rows = .data$variable == .env$variable}.
}
}
\keyword{internal}
