% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{fmt}
\alias{fmt}
\title{Set a column format with a formatter function}
\usage{
fmt(data, columns = everything(), rows = everything(), compat = NULL, fns)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\code{\link[=rows-columns]{<column-targeting expression>}} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\code{\link[=rows-columns]{<row-targeting expression>}} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
undergo formatting. The default \code{\link[=everything]{everything()}} results in all rows in
\code{columns} being formatted. Alternatively, we can supply a vector of row
captions within \code{c()}, a vector of row indices, or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{compat}{\emph{Formatting compatibility}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional vector that provides the compatible classes for the formatting.
By default this is \code{NULL}.}

\item{fns}{\emph{Formatting functions}

\verb{function|list of functions} // \strong{required}

Either a single formatting function or a named list of functions. Can also
be anonymous functions, in both base R (\verb{\\(x) x + 1}) and \code{rlang}
(\code{~.x + 1}) syntax.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{fmt()} provides a way to execute custom formatting functionality with raw
data values in a way that can consider all output contexts.

Along with the \code{columns} and \code{rows} arguments that provide some precision in
targeting data cells, the \code{fns} argument allows you to define one or more
functions for manipulating the raw data.

If providing a single function to \code{fns}, the recommended format is in the
form: \code{fns = function(x) ...}. This single function will format the targeted
data cells the same way regardless of the output format (e.g., HTML, LaTeX,
RTF).

If you require formatting of \code{x} that depends on the output format, a list of
functions can be provided for the \code{html}, \code{latex}, \code{rtf}, and \code{default}
contexts. This can be in the form of \code{fns = list(html = function(x) ..., latex = function(x) ..., default = function(x) ...)}. In this
multiple-function case, we recommended including the \code{default} function as a
fallback if all contexts aren't provided.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table. We'll format the
numeric values in the \code{num} column with \code{fmt()}. We supply a functions to
the \code{fns} argument. This supplied function will take  values in the
column (\code{x}), multiply them by 1000, and exclose them in single quotes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(-row, -group) |>
  gt() |>
  fmt(
    columns = num,
    fns = function(x) \{
      paste0("'", x * 1000, "'")
    \}
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_1.png" alt="This image of a table was generated from the first code example in the `fmt()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-31
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_chem}()},
\code{\link{fmt_country}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_email}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_icon}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_number_si}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_tf}()},
\code{\link{fmt_time}()},
\code{\link{fmt_units}()},
\code{\link{fmt_url}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
