\name{dataOrder}
\alias{dataOrder}
\title{Order a data frame by subject and ordered time variable}
\usage{dataOrder(data, datanames=c("id","atime","catime",
                                            "intervention","outcome"))}
\description{Orders a user supplied data frame by subject and ordered time
   variable.}
\arguments{
 \item{data}{A data frame structured as those from function
 \code{\link{simdataExtract}}.}
 \item{datanames}{Names of the five required data variables; participant
   identifier, time-point, standardized (continuous) time-point (see
  \code{\link{tfuStandard}}), intervention arm and outcome, in that order;
  e.g. \code{c("id","atime","catime","intervention","outcome"))}.}
}
\value{
 Returns an ordered data frame.
}
\examples{
 data(qol)
 oqol <- dataOrder(qol,datanames=c("Subject","Weeks","STime","Treat","QoL"))
 head(qol, n=50)
}
