% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_hubs.R
\name{predict_hubs}
\alias{predict_hubs}
\title{Predicts the degree of hubs of an new graph}
\usage{
predict_hubs(gr, n, k = NULL)
}
\arguments{
\item{gr}{The input graph}

\item{n}{The number of nodes in the new graph}

\item{k}{The number of hubs. Default is \code{NULL}}
}
\value{
A vector of hub degrees
}
\description{
Predicts the degree of hubs of an unseen graph given a graph generated
from the same process.
}
\examples{
library(igraph)
gr <- sample_pa(10000, power = 1.2, directed = FALSE)
predict_hubs(gr, n = 11000)
}
