% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{label_party_margin}
\alias{label_party_margin}
\alias{label_party_pct}
\title{Label Partisan Vote Shares}
\usage{
label_party_margin(midpoint = 0.5, reverse = FALSE, accuracy = 1)

label_party_pct(midpoint = 0.5, reverse = FALSE, accuracy = 1)
}
\arguments{
\item{midpoint}{Either 0.5, the default, or 0. For \code{label_party_margin()}, if
zero, scale will not be doubled (0.05 becomes "D+5" with \code{midpoint=0},
while 0.55 becomes "D+10" with `midpoint=0.5)}

\item{reverse}{If \code{TRUE}, reverse "D" and "R".}

\item{accuracy}{As with \link[scales:comma]{scales::number_format}}
}
\value{
A labeling function
}
\description{
For example, a 45\% Democratic vote share becomes "R+10" or "55\% R".
}
\examples{
labeler = label_party_margin(accuracy=0.1)
labeler(c(0.3, 0.5, 0.543))
labeler = label_party_margin(reverse=TRUE)
labeler(c(0.3, 0.5, 0.543))

}
\concept{labels}
