% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-water-indices.R
\name{list_water_indices}
\alias{list_water_indices}
\title{Get comprehensive list of available water indices}
\usage{
list_water_indices(detailed = FALSE, application_filter = "all")
}
\arguments{
\item{detailed}{Return detailed information including formulas and applications}

\item{application_filter}{Filter by application: "all", "water_detection", "moisture_monitoring", "drought_assessment"}
}
\value{
Data frame with water index information
}
\description{
Returns detailed information about all available water indices including
formulas, required bands, applications, and interpretation guidelines.
}
\examples{
\donttest{
# All available water indices
water_indices <- list_water_indices()

# Detailed information with formulas
detailed_info <- list_water_indices(detailed = TRUE)

# Only water detection indices
water_detection <- list_water_indices(application_filter = "water_detection")
}

}
