% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictLayer.R
\name{PredictLayer}
\alias{PredictLayer}
\title{PredictLayer Class}
\description{
This class implements a layer. A \link{PredictLayer} object can only exist as a component of a \link{Predicting} object.

A predicted layer can only contain \link{PredictData}.
}
\seealso{
\link{Training}, \link{Lrner}, \link{TrainData}, \link{TestData} and \link{Model}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{PredictLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictLayer-new}{\code{PredictLayer$new()}}
\item \href{#method-PredictLayer-print}{\code{PredictLayer$print()}}
\item \href{#method-PredictLayer-getPredicting}{\code{PredictLayer$getPredicting()}}
\item \href{#method-PredictLayer-getIndIDs}{\code{PredictLayer$getIndIDs()}}
\item \href{#method-PredictLayer-getPredictData}{\code{PredictLayer$getPredictData()}}
\item \href{#method-PredictLayer-setPredicting}{\code{PredictLayer$setPredicting()}}
\item \href{#method-PredictLayer-summary}{\code{PredictLayer$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$new(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The layer ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-getPredicting"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-getPredicting}{}}}
\subsection{Method \code{getPredicting()}}{
Getter of the current predicting object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$getPredicting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current predicting object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Getter of IDS from the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-getPredictData"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-getPredictData}{}}}
\subsection{Method \code{getPredictData()}}{
Getter of the predicted data stored on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$getPredictData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{PredictData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-setPredicting"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-setPredicting}{}}}
\subsection{Method \code{setPredicting()}}{
Assigns a predicting object to the predicted layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$setPredicting(predicting)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predicting}}{\code{Predicting} \cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictLayer-summary"></a>}}
\if{latex}{\out{\hypertarget{method-PredictLayer-summary}{}}}
\subsection{Method \code{summary()}}{
Generate summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictLayer$summary()}\if{html}{\out{</div>}}
}

}
}
