% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulatePP}
\alias{simulatePP}
\title{Simulate a Point Process}
\usage{
simulatePP(
  agentVarData = data.frame(outcome = c(0, 1, 2), A = c(0, 0, 0), B = c(1/100, 1/500,
    1/500), C = c(1/500, 1/250, 1/100), D = c(1/100, 1/100, 1/100), E = c(1/500, 1/500,
    1/500), F = c(1/250, 1/250, 1/250)),
  agentKappaData = data.frame(agent = c("A", "B", "C", "D", "E", "F"), clusterAgent =
    c(NA, "A", "B", "C", NA, "A"), kappa = c(20, 5, 4, 2, 15, 5)),
  unitsPerOutcome = 20,
  replicatesPerUnit = 5,
  silent = FALSE
)
}
\arguments{
\item{agentVarData}{(Optional) Data.frame describing variances with each
agent type.

The data.frame has a outcome column and a named column for each agent type.
Currently, these names are mandatory.}

\item{agentKappaData}{(Optional) Data.frame describing agent interactions.

The data.frame has a agent column giving agent names (matching agentVarData),
a clusterAgent column indicating which agent the agent clusters (put NA
if the agent doesn't cluster or clusters a hidden agent / self-clusters),
and a kappa column directing the number of agents of per replicate.}

\item{unitsPerOutcome}{(Optional) Numeric indicating the number of units per
outcome.}

\item{replicatesPerUnit}{(Optional) Numeric indicating the number of
replicates, or repeated measures, per unit.}

\item{silent}{(Optional) Boolean indicating if progress output should be
printed.}
}
\value{
Data.frame containing each point the defined patterns.

The data.frame has columns for outcome, x coordinate, y coordinate, agent
type, unit, and replicate id.
}
\description{
This function simulates a point pattern with optional clustering (visible
and invisible). Multiple outcomes, units, and replicates are
possible, e.g. a 3 stage disease (outcomes) over 20 people (units) with
3 images each (replicates).
}
\examples{
data <- simulatePP(
  agentVarData = data.frame(
    "outcome" = c(0, 1),
    "A" = c(0, 0),
    "B" = c(1 / 100, 1 / 500),
    "C" = c(1 / 500, 1 / 250),
    "D" = c(1 / 100, 1 / 100),
    "E" = c(1 / 500, 1 / 500)
  ),
  agentKappaData = data.frame(
    "agent" = c("A", "B", "C", "D", "E"),
    "clusterAgent" = c(NA, "A", "B", "C", NA),
    "kappa" = c(10, 3, 2, 1, 8)
  ),
  unitsPerOutcome = 4,
  replicatesPerUnit = 1
)
}
