% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funIHC.R
\name{funIHC}
\alias{funIHC}
\title{Functional Iterative Hierarchical Clustering}
\usage{
funIHC(x, Data, type = 0)
}
\arguments{
\item{x}{Numeric vector of time points.}

\item{Data}{Numeric matrix with rows corresponding to time points
and columns to individual curves.}

\item{type}{Integer specifying representation:
0 = curves (default),
1 = first derivative,
2 = basis coefficients.}
}
\value{
A list containing:
\item{label}{Integer vector of cluster labels.}
\item{clusters}{Clustered observations.}
\item{fd}{Functional data object.}
\item{mean_clusters_mat}{Cluster means.}
}
\description{
Performs Functional Iterative Hierarchical Clustering (funIHC) as described in the paper: Higgins, C., Carey, M. Addressing class imbalance in functional data clustering. Adv Data Anal Classif (2024). https://doi.org/10.1007/s11634-024-00611-8
}
\examples{
\donttest{
## Load example data within the package
rds_path <- system.file("extdata", "U1505.rds", package = "funIHC")
example_data <- readRDS(rds_path)

## Extract curves
Data <- example_data$Data
Data <- t(Data)
x = 1:15 #number of time points

## Run functional iterative hierarchical clustering
res <- funIHC(x,Data)

## Inspect cluster assignments
table(res$label)
}

}
