% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{run_fmi}
\alias{run_fmi}
\title{Run Hierarchical Functional Measurement Invariance (FMI) Tests}
\usage{
run_fmi(
  Y_mat,
  group_vec,
  argvals,
  alpha = 0.05,
  npc = NULL,
  target_pve = 0.95,
  max_npc = 6L,
  n_perms = 499L,
  strict_test = FALSE,
  progress = interactive()
)
}
\arguments{
\item{Y_mat}{A numeric matrix (N x M) where N is subjects, M is time points.}

\item{group_vec}{A vector of length N specifying group membership (2 groups).}

\item{argvals}{A numeric vector of length M listing the observation points.}

\item{alpha}{Significance level (default: 0.05).}

\item{npc}{Optional. The number of FPCs. If NULL (default), it is
determined automatically by \code{determine_npc}.}

\item{target_pve}{The target PVE if \code{npc} is NULL (default: 0.95).}

\item{max_npc}{The max FPCs if \code{npc} is NULL (default: 6L).}

\item{n_perms}{The number of permutations (default: 499L).}

\item{strict_test}{Boolean. Whether to perform the strict invariance test
(default: FALSE).}

\item{progress}{Boolean. Show progress bars? (default: interactive()).}
}
\value{
A list containing test results for each invariance level,
settings, and the pooled FPCA object.
}
\description{
A wrapper function that performs a sequence of permutation tests
for configural, metric, scalar, and (optionally) strict invariance.
}
\examples{
\donttest{
  # Use small N and n_perms for a quick example
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  fmi_results <- run_fmi(
    Y_mat = sim$Y_mat,
    group_vec = sim$group_vec,
    argvals = sim$argvals,
    n_perms = 9, # Use 499+ for actual research
    progress = FALSE
  )
 print(fmi_results)
}
}
