% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_flow_test.R
\name{flow_test}
\alias{flow_test}
\title{Build Report From Tests}
\usage{
flow_test(
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  swap = TRUE,
  out = NULL,
  failed_only = FALSE
)
}
\arguments{
\item{prefix}{prefix to use for special comments in our code used as block headers,
must start with \code{"#"}, several prefixes can be provided}

\item{code}{Whether to display the code in code blocks or only the header,
to be more compact, if \code{NA}, the code will be displayed only if no header
is defined by special comments}

\item{narrow}{\code{TRUE} makes sure the diagram stays centered on one column
(they'll be longer but won't shift to the right)}

\item{truncate}{maximum number of characters to be printed per line}

\item{swap}{whether to change \code{var <- if(cond) expr} into
\code{if(cond) var <- expr} so the diagram displays better}

\item{out}{path to html output, if left \code{NULL} a temp \emph{html}
file will be created and opened.}

\item{failed_only}{whether to restrict the report to failing tests only}
}
\value{
Returns \code{NULL} invisibly (called for side effects)
}
\description{
Build a markdown report from test scripts, showing the paths taken in tested
functions, and where they fail if they do.
See also the vignette \emph{"Build reports to document functions and unit tests"}.
}
