% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHSL-tiles.R
\docType{data}
\name{GHSL_tiles}
\alias{GHSL_tiles}
\title{A dataframe with existing GHSL tiles}
\format{
\subsection{\code{GHSL_tiles}}{

A dataframe with 375 rows and 6 columns
\describe{
\item{tile_id}{id of the tile}
\item{left, top, right, bottom}{The coordinates of the bounding box of the tile (in Mollweide, EPSG: 54009)}
\item{geometry}{\code{sfc_POLYGON} geometry of the tile}
}
}
}
\source{
\url{https://ghsl.jrc.ec.europa.eu/download/GHSL_data_54009_shapefile.zip}
}
\usage{
GHSL_tiles
}
\description{
The Global Human Settlement Layer (GHSL) divides the world into different rectangular areas called "tiles". These tiles can be used to download the GHSL products from the website (see \href{https://ghsl.jrc.ec.europa.eu/download.php}{GHSL Download page}).

The dataset \code{GHSL_tiles} contains the geometry and metadata of all valid tiles.
}
\details{
Spatial distribution of the GHSL tiles:
\figure{figure_GHSL_tiles.png}{GHSL tiles}
}
\keyword{datasets}
