% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-assessment.R
\name{model_assessment}
\alias{model_assessment}
\title{Model Assessment}
\usage{
model_assessment(
  data,
  distribution,
  method,
  prior = NULL,
  ns_years = NULL,
  ns_structure = NULL,
  alpha = 0.05,
  pp_formula = "Weibull",
  ci = NULL
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{method}{Character scalar specifying the estimation method.
Must be \code{"L-moments"}, \code{"MLE"}, or \code{"GMLE"}.}

\item{prior}{Numeric vector of length 2. Specifies the parameters of the
Beta prior for the shape parameter \eqn{\kappa}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}

\item{pp_formula}{Character string specifying the plotting position formula.
Must \code{"Weibull"} (default), \code{"Blom"}, \code{"Cunnane"}, \code{"Gringorten"}, or \code{"Hazen"}.}

\item{ci}{\strong{For S-FFA only}. Dataframe containing return periods (in the column
\code{periods}) and confidence intervals (in the columns \code{lower} and \code{upper}). Dataframes
in this format can be generated with \code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}}, \code{\link[=uncertainty_rfpl]{uncertainty_rfpl()}},
or \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}}.}
}
\value{
List containing the results of model assessment:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{q_theoretical}: The theoretical return level estimates based on the plotting
positions. Normalized for nonstationary models.
\item \code{q_empirical}: The empirical return levels. Normalized for nonstationary models.
\item \code{metrics}: A list of model assessment metrics (see details).
}
}
\description{
Computes various metrics for assessing the quality of a fitted flood frequency model.
Metrics include accuracy (residual statistics), fitting efficiency (information
criteria), and uncertainty (coverage based metrics using confidence intervals).

\strong{For NS-FFA}: The metrics are computed from the normalized empirical/theoretical
quantiles, which are determined based on the selected distribution family. Therefore,
metrics from stationary and nonstationary models should not be compared.
}
\details{
These metrics are are computed for all models:
\itemize{
\item \code{AIC_MLL}: Akaike Information Criterion, computed using the maximum log-likelihood.
\item \code{BIC_MLL}: Bayesian Information Criterion, computed using the maximum log-likelihood.
\item \code{R2}: Coefficient of determination from linear regression of estimates vs. data.
\item \code{RMSE}: Root mean squared error of quantile estimates.
\item \code{bias}: Mean bias of quantile estimates.
\item \code{AIC_RMSE}: Akaike Information Criterion, computed using the RMSE.
\item \code{BIC_RMSE}: Bayesian Information Criterion, computed using the RMSE.
}

These metrics are only computed  \emph{if the \code{ci} argument is provided}:
\itemize{
\item \code{AW}: Average width of the confidence interval(s).
\item \code{POC}: Percent of observations covered by the confidence interval(s).
\item \code{CWI}: Confidence width index, a metric that combines \code{AW} and \code{POC}.
}
}
\examples{
# Initialize example data and params
data <- rnorm(n = 100, mean = 100, sd = 10)
params <- c(100, 10)

# Perform uncertainty analysis
ci <- uncertainty_bootstrap(data, "NOR", "L-moments")$ci

# Run model assessment
model_assessment(data, "NOR", "L-moments", ci = ci)

}
\seealso{
\code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}}, \code{\link[=uncertainty_rfpl]{uncertainty_rfpl()}}, \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}},
\code{\link[=plot_sffa_assessment]{plot_sffa_assessment()}}, \code{\link[=plot_nsffa_assessment]{plot_nsffa_assessment()}}
}
