#' CAN-08NH021
#'
#' A dataframe of annual maximum series observations for 
#' station 08NH021, KOOTENAI RIVER AT PORTHILL in British Columbia, Canada. 
#'
#' @section Additional Information:
#' This is a regulated station that is not in the RHBN. Additionally,
#' - The Libby dam was constructed upstream of this station in 1972.
#' - The Pettitt test finds evidence of a change point in 1972 at the 0.05 significance level.
#' - The MKS test finds evidence of change points in 1960 & 1985 at the 0.05 significance level.
#' 
#' This dataset is an excellent introduction to change point detection and piecewise NS-FFA.
#'
#' @format A dataframe with 91 rows and 2 columns spanning the period 1928-2018.
#'
#' @source Meteorological Service of Canada (MSC) GeoMet Platform
#'
#' @details Variables:
#' - `max`: Numeric; the observed annual maximum series, in m\eqn{^3}{^3}/s.
#' - `year`: Integer; the corresponding years.

"CAN_08NH021"
