% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{plikert}
\alias{plikert}
\title{Likert distribution function}
\usage{
plikert(q, prob, labels = names(prob))
}
\arguments{
\item{q}{the vector of quantiles}

\item{prob}{a vector of probabilities or counts; if named, the output is a factor}

\item{labels}{a vector of values, defaults to names(prob) or 1:length(prob), if numeric, the output is numeric}
}
\value{
a vector of the densities
}
\description{
Likert distribution function
}
\examples{
q <- 1:5
prob <- c(.1, .2, .4, .2, .1)
plikert(q, prob)

q <- c("A", "C", "B", "B")
prob <- c(A = 10, B = 20, C = 30)
plikert(q, prob)

# specify labels if prob not named and not 1:length(prob)
labels <- -2:2 
q <- labels
prob <- rep(1, length(labels)) # uniform probability
plikert(q, prob, labels)
}
