% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coefs.R
\name{get_coefs}
\alias{get_coefs}
\title{Get Coefficients from Data}
\usage{
get_coefs(data, formula = NULL, fun = c("lm", "glm", "lmer", "glmer"), ...)
}
\arguments{
\item{data}{A dataset in long format}

\item{formula}{A formula (can be extracted from datasets created by sim_design)}

\item{fun}{the model function (one of "lm", "glm", "lmer",  or "glmer")}

\item{...}{Further arguments to the model function}
}
\value{
a list of the model coefficients
}
\description{
You need model coefficients to simulate multilevel data, and can get them from data simulated from parameters using sim_design() or rmulti().
}
\examples{
# simulate some data
data <- sim_design(within = 2, between = 2, 
                   mu = c(1, 0, 1, 1), 
                   long = TRUE, empirical = TRUE)

# get coefs for the full factorial model
get_coefs(data)

# a reduced model
get_coefs(data, y ~ B1 + W1)

# specify a different model function
data$y <- norm2binom(data$y)
get_coefs(data, fun = "glm", family = binomial)
}
