% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_performance_and_fairness.R
\name{plot.performance_and_fairness}
\alias{plot.performance_and_fairness}
\title{Plot fairness and performance}
\usage{
\method{plot}{performance_and_fairness}(x, ...)
}
\arguments{
\item{x}{\code{performance_and_fairness} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot} object
}
\description{
visualize fairness and model metric at the same time. Note that fairness metric parity scale is reversed so that the best models are in top right corner.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)


explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

paf <- performance_and_fairness(fobject)
plot(paf)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200
)

explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

# same explainers with different cutoffs for female
fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
  protected = german$Sex,
  privileged = "male",
  cutoff = list(female = 0.4),
  label = c("lm_2", "rf_2")
)

paf <- performance_and_fairness(fobject)

plot(paf)
}

}
