% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tsfmUpDn.R
\name{print.tsfmUpDn}
\alias{print.tsfmUpDn}
\title{Prints out a fitted up and down market time series factor model object}
\usage{
\method{print}{tsfmUpDn}(x, digits = max(3, .Options$digits - 3), ...)
}
\arguments{
\item{x}{an object of class \code{tsfmUpDn} produced by \code{fitTsfmUpDn}.}

\item{digits}{an integer value, to indicate the required number of 
significant digits. Default is 3.}

\item{...}{optional arguments passed to the \code{print} method.}
}
\value{
\code{print.tsfmUpDn} prints a brief summary of an object of class 
\code{tsfmUpDn}.
}
\description{
S3 \code{print} method for object of class \code{tsfmUpDn}. Prints 
the call, factor model dimension, regression coefficients, r-squared and 
residual volatilities from the fitted object.
}
\examples{
 # load data
data(managers, package = 'PerformanceAnalytics')
colnames(managers)
 # Make syntactically valid column names
colnames(managers) <- make.names( colnames(managers))
colnames(managers)

# example: Up and down market factor model with LS fit
fitUpDn <- fitTsfmUpDn(asset.names=colnames(managers[,(1:6)]),
                       mkt.name="SP500.TR",
                       data=managers, 
                       fit.method="LS")
 
print(fitUpDn)

}
\seealso{
\code{\link{fitTsfmUpDn}}, \code{\link{summary.tsfmUpDn}}
}
\author{
Yi-An Chen and Sangeetha Srinivasan
}
