% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names2labels.R
\name{names2labels}
\alias{names2labels}
\alias{n2l}
\title{Replace data.frame/list names with corresponding variables labels.}
\usage{
names2labels(x, exclude = NULL, keep_names = FALSE)

n2l(x, exclude = NULL, keep_names = FALSE)
}
\arguments{
\item{x}{data.frame/list.}

\item{exclude}{logical/integer/character columns which names should be left
unchanged. Only applicable to list/data.frame.}

\item{keep_names}{logical. If TRUE original column names will be kept with
labels. Only applicable to list/data.frame.}
}
\value{
Object of the same type as x but with variable labels instead of
  names.
}
\description{
\code{names2labels} replaces data.frame/list names with corresponding 
variables labels. If there are no labels for some variables their names
remain unchanged. \code{n2l} is just shortcut for \code{names2labels}.
}
\examples{
data(mtcars)
mtcars = mtcars \%>\% 
    apply_labels(
        mpg = "Miles/(US) gallon",
        cyl = "Number of cylinders",
        disp = "Displacement (cu.in.)",
        hp = "Gross horsepower",
        drat = "Rear axle ratio",
        wt = "Weight (lb/1000)",
        qsec = "1/4 mile time",
        vs = "Engine",
        vs = c("V-engine" = 0, 
                "Straight engine" = 1),
        am = "Transmission",
        am = c(automatic = 0, 
                manual=1),
        gear = "Number of forward gears",
        carb = "Number of carburetors"
    )

# without original names
# note: we exclude dependent variable 'mpg' from conversion to use its short name in formula
summary(lm(mpg ~ ., data = names2labels(mtcars, exclude = "mpg")))
# with names
summary(lm(mpg ~ ., data = names2labels(mtcars, exclude = "mpg", keep_names = TRUE)))
}
\seealso{
\link{values2labels}, \link{val_lab},  \link{var_lab}
}
