% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excerptr.R
\name{excerptr}
\alias{excerptr}
\title{Excerpt Structuring Comments and Set a Table of Contents.}
\usage{
excerptr(
  file_name,
  comment_character = "#",
  magic_character = "\%",
  output_path = "",
  allow_pep8 = TRUE,
  prefix = "",
  postfix = "",
  run_pandoc = TRUE,
  compile_latex = FALSE,
  pandoc_formats = "tex"
)
}
\arguments{
\item{file_name}{Name the file from which to excerpt.}

\item{comment_character}{Should be "#" for R.}

\item{magic_character}{The magic character marking the structuring comments
in \code{file_name}.}

\item{output_path}{Name the path where to output to.}

\item{allow_pep8}{Don't bother. See \command{excerpts.excerpts} for details.}

\item{prefix}{Give a prefix to use for output files.}

\item{postfix}{Give a postfix to use for output files.}

\item{run_pandoc}{Try to run \command{pandoc} on the output?}

\item{compile_latex}{Try to compile LaTeX if \command{pandoc} has output
LaTeX?}

\item{pandoc_formats}{A character vector naming the output formats for
\command{pandoc}.}
}
\value{
The status of \command{excerpts.excerpts}.
}
\description{
Just a wrapper to the python function \command{excerpts.excerpts}.
See \url{https://pypi.org/project/excerpts/} for details.
}
\examples{
if (reticulate::py_available(initialize = TRUE)) {
    root <- system.file(package = "excerptr")
    test_files <- file.path(root, "excerpts", "tests", "files")
    outpath <- tempdir()
    python_source <- "some_code.py"
    f <- normalizePath(file.path(test_files, python_source))
    cat(readLines(f), sep = "\n")
    tryCatch(
             excerptr(file_name = file.path(test_files, python_source),
                      output_path = tempdir(), run_pandoc = FALSE,
                      compile_latex = FALSE,
                      pandoc_formats = c("tex", "html")),
             error = identity)
    f <- file.path(outpath, sub("\\\\.py$", ".md", python_source))
    if (!fritools::is_cran()) cat(readLines(f), sep = "\n")
}
}
