% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_histogram_grid}
\alias{plot_histogram_grid}
\title{Grid of multiple variable histograms}
\usage{
plot_histogram_grid(
  sessions,
  vars = evprof::sessions_summary_feature_names,
  binwidths = rep(1, length(vars)),
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof standard format}

\item{vars}{vector of characters, variables to plot}

\item{binwidths}{vector of integers, binwidths of each variable histogram.
The length of the vector must correspond to the length of the \code{vars} parameter.}

\item{nrow}{integer, number of rows of the plot grid}

\item{ncol}{integer, number of columns of the plot grid}
}
\value{
grid plot
}
\description{
Grid of multiple variable histograms
}
\examples{
plot_histogram_grid(california_ev_sessions)
plot_histogram_grid(california_ev_sessions, vars = c("Energy", "Power"))

}
