% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetcv.test.R
\name{hetcv.test}
\alias{hetcv.test}
\title{The Heterogeneity Test for Grouped Average Treatment Effects (GATEs) under Cross Validation in Randomized Experiments}
\usage{
hetcv.test(D, tau, Y, ind, ngates = 5)
}
\arguments{
\item{D}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A vector of the unit-level continuous score. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{ind}{A vector of integers (between 1 and number of folds inclusive) indicating which testing set does each sample belong to.}

\item{ngates}{The number of groups to separate the data into. The groups are determined by \code{tau}. Default is 5.}
}
\value{
A list that contains the following items: \item{stat}{The estimated
statistic for the test of heterogeneity under cross-validation.} \item{pval}{The p-value of the null
hypothesis (that the treatment effects are homogeneous)}
}
\description{
This function calculates statistics related to the test of heterogeneous treatment effects across groups under cross-validation.
}
\details{
The details of the methods for this design are given in Imai and Li (2022).
}
\examples{
D = c(1,0,1,0,1,0,1,0)
tau = matrix(c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,-0.5,-0.3,-0.1,0.1,0.3,0.5,0.7,0.9),nrow = 8, ncol = 2)
Y = c(4,5,0,2,4,1,-4,3)
ind = c(rep(1,4),rep(2,4))
hettestlist <- hetcv.test(D,tau,Y,ind,ngates=2)
hettestlist$stat
hettestlist$pval
}
\references{
Imai and Li (2022). \dQuote{Statistical Inference for Heterogeneous Treatment Effects Discovered by Generic Machine Learning in Randomized Experiments},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{evaluation}
