% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boin_comb_selector.R, R/interface.R,
%   R/simulations.R
\name{doses_given.boin_comb_selector}
\alias{doses_given.boin_comb_selector}
\alias{doses_given}
\alias{doses_given.simulations}
\title{Doses given to patients.}
\usage{
\method{doses_given}{boin_comb_selector}(x, dose_string = FALSE, ...)

doses_given(x, ...)

\method{doses_given}{simulations}(x, dose_string = FALSE, ...)
}
\arguments{
\item{x}{Object of type \code{\link{selector}}.}

\item{dose_string}{TRUE to return vector of character dose-strings; FALSE
(the default) to get a list of matrices, one for each simulated trial, with
the dose-indices of the different treatments in columns and patients in rows.}

\item{...}{Extra args are passed onwards.}
}
\value{
an integer vector
}
\description{
Get a vector of the dose-levels that have been administered to patients.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model <- get_dfcrm(skeleton = skeleton, target = target)
fit <- model \%>\% fit('1NNN 2NTN')
fit \%>\% doses_given()
}
