% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_misfit.R
\name{plot_misfit}
\alias{plot_misfit}
\title{Plot person misfit in 2D/3D using stored thresholds}
\usage{
plot_misfit(
  object,
  stats = NULL,
  threeD = FALSE,
  any = FALSE,
  planes = TRUE,
  label_ids = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{epmfd_misfit} or \code{epmfd_clean} object. If \code{epmfd_clean}
is supplied, its \verb{$misfit} component is used.}

\item{stats}{Character vector of length 2 or 3 naming statistics found in
\code{object$scores} (e.g., \code{c("Gnp","U3p","lpz")}). If \code{NULL},
the first up to three available statistics are used.}

\item{threeD}{Logical. If \code{TRUE} and three statistics are available, a 3D
\pkg{plotly} plot is drawn; otherwise the function falls back
to 2D and emits a warning.}

\item{any}{Logical. Colouring rule:
\itemize{
\item \code{FALSE} (default): only two classes - \emph{all}
cut-offs exceeded (red) vs \emph{none} exceeded (blue).
\item \code{TRUE}: adds an intermediate class (orange) for
\emph{partial} exceedance (in 2D: exactly one; in 3D:
one or two).
}}

\item{planes}{Logical (3D only). If \code{TRUE}, draw three semi-transparent
planes at the x, y, and z cut-off values; if \code{FALSE}, no
planes are shown. Ignored for 2D plots.}

\item{label_ids}{Logical. If \code{TRUE}, label points by \code{id} in 2D plots
(uses \pkg{ggrepel} when available).}

\item{...}{Additional aesthetics passed to
\code{ggplot2::geom_point()} (2D) or
\code{plotly::add_markers()} (3D), such as \code{alpha}, \code{size},
etc.}
}
\value{
A \code{ggplot} object (2D), a named list of \code{ggplot}s (all 2D pairs), or a
\code{plotly} object (3D), depending on \code{stats} and \code{threeD}.
}
\description{
\code{plot_misfit()} visualizes person-level misfit statistics stored in an
\code{epmfd_misfit} object. It supports:
\itemize{
\item \strong{2D}: scatter plots for all pairwise combinations of the
selected statistics (or a single 2D plot if exactly two are given).
Points are coloured by the joint exceedance logic (see \code{any}).
Axis titles are the statistic names; the main title shows the cut-offs
in parentheses, and dashed lines mark the cut-offs per axis.
\item \strong{3D}: an interactive scatter using \pkg{plotly} if three
statistics are supplied; optionally adds three semi-transparent planes
at the x/y/z cut-offs when \code{planes = TRUE}.
}
}
\details{
\strong{Cut-off logic.} For each selected statistic, a person is deemed to
exceed if its score is greater than the cut-off for upper-tailed statistics
or less than the cut-off for lower-tailed statistics. In 2D, dashed vertical
and horizontal lines indicate the cut-offs; the plot title shows
\code{"Y (cutY) vs X (cutX)"} with formatted values. In 3D, axis titles
include the cut-off values in parentheses, and (optionally) three grey planes
make the cut-offs explicit.

\strong{Returned value.} With two statistics, a single \code{ggplot} is returned;
with three statistics and \code{threeD = FALSE}, a named list of \code{ggplot}s is
returned for all 2D pairs. With \code{threeD = TRUE} and three statistics, a
\code{plotly} object is returned.

\strong{Dependencies.} This function uses \pkg{ggplot2} for 2D plots and,
for 3D, \pkg{plotly} (required only when \code{threeD = TRUE}). Optional labels in
2D use \pkg{ggrepel} when installed.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Suppose 'mf' is an epmfd_misfit with scores Gnp, U3p, lpz

# 2D: single plot
plot_misfit(mf, stats = c("Gnp","U3p"), any = TRUE)

# 2D: all pairwise plots
plot_misfit(mf, stats = c("Gnp","U3p","lpz"))

# 3D: with cut-off planes
plot_misfit(mf, stats = c("Gnp","U3p","lpz"), threeD = TRUE, planes = TRUE)

# 3D: points only (no planes)
plot_misfit(mf, stats = c("Gnp","U3p","lpz"), threeD = TRUE, planes = FALSE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=misfit_epmfd]{misfit_epmfd()}} for computing statistics and thresholds;
\code{\link[=clean_epmfd]{clean_epmfd()}} for removing misfitting persons.
}
