% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_epmfd.R
\name{clean_epmfd}
\alias{clean_epmfd}
\title{Remove misfitting persons from an epmfd_misfit object}
\usage{
clean_epmfd(misfit, criterion = c("union", "intersection"), clean_item = FALSE)
}
\arguments{
\item{misfit}{An \code{epmfd_misfit} object returned by \code{\link[=misfit_epmfd]{misfit_epmfd()}}.}

\item{criterion}{Character string, either \code{"union"} (default) or \code{"intersection"}.}

\item{clean_item}{is a logical argument. If clean_item=TRUE, then the function can clean items. The defaul value is FALSE.}
}
\value{
An \code{epmfd_clean} list with:
\itemize{
\item \code{raw}: An \code{epmfd_raw} object containing only the retained persons and
items, directly usable in \code{\link[=scale_epmfd]{scale_epmfd()}}.
\item \code{clean_data}: The cleaned raw data frame (persons × kept items).
\item \code{n_removed}: Number of persons removed.
\item \code{criterion}: The applied decision rule.
\item \code{misfit}: The original \code{epmfd_misfit} object (as provided).
}
}
\description{
\code{clean_epmfd()} removes individuals flagged as misfitting according to
a chosen decision rule and returns a cleaned dataset that can be passed
directly to \code{\link[=scale_epmfd]{scale_epmfd()}}.
}
\details{
The function uses logical misfit indicators stored in \code{misfit$table},
including:
\itemize{
\item \code{misfit_any}: \code{TRUE} if at least one statistic flagged the person.
\item Statistic-specific columns (e.g., \code{Gnp}, \code{U3p}, \code{lpz}) indicating
per-statistic misfit decisions.
}
The set of statistics actually considered is taken from \code{misfit$stats}.
Under the \code{"intersection"} rule, a person is removed only if \strong{all} of those
statistics are \code{TRUE}. Internally, \code{rowSums(..., na.rm = TRUE)} is
used so that \code{NA} values do not force removal (i.e., \code{NA} behaves
as “not flagged” in the intersection count).

Only items listed in \code{misfit$scaled$kept} are retained in the output.
Person identifiers from the original raw object are preserved for the kept rows.
}
\section{Criterion}{

\itemize{
\item \code{"union"} (default): A person is removed if \strong{at least one} statistic
(e.g., Gnp, U3p, lpz) flags them as misfitting. This is stricter.
\item \code{"intersection"}: A person is removed \strong{only if all} statistics flag them
as misfitting. This is more lenient.
}
}

\examples{

library(epmfd)
data<-load_epmfd(sampledata)
scaling_data<-scale_epmfd(data)
misfit_result<-misfit_epmfd(scaling_data)
clean_data<-clean_epmfd(misfit_result)
head(clean_data$clean_data)
dim(data$data)  # the dimension of raw data
dim(clean_data$clean_data)  # the dimension of clean data
}
\seealso{
\code{\link[=misfit_epmfd]{misfit_epmfd()}}, \code{\link[=scale_epmfd]{scale_epmfd()}}
}
