% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity_tools.R
\name{add_entities_from_dataframe}
\alias{add_entities_from_dataframe}
\title{Add entities to a model according to a data.frame}
\usage{
add_entities_from_dataframe(model, entities, col_name, col_number, ...)
}
\arguments{
\item{model}{An \link{epiworld_model} object.}

\item{entities}{A \code{data.frame} with the entities to add. It must contain two
columns: entity names (character) and size (proportion or integer).}

\item{col_name}{The name of the column in \code{entities} that contains the
entity names.}

\item{col_number}{The name of the column in \code{entities} that contains the
entity sizes (either as proportions or integers).}

\item{...}{Further arguments passed to \code{\link[=add_entity]{add_entity()}}}
}
\value{
Inivisible the model with the added entities.
}
\description{
Helper function that facilities creating entities and adding them to
models. It is a wrapper of \code{\link[=add_entity]{add_entity()}}.
}
\examples{
# Start off creating three entities.
# Individuals will be distributed randomly between the three.
entities <- data.frame(
  name = c("Pop 1", "Pop 2", "Pop 3"),
  size = rep(3e3, 3)
)

# Row-stochastic matrix (rowsums 1)
cmatrix <- c(
  c(0.9, 0.05, 0.05),
  c(0.1, 0.8, 0.1),
  c(0.1, 0.2, 0.7)
) |> matrix(byrow = TRUE, nrow = 3)

flu_model <- ModelSIRMixing(
  name              = "Flu",
  n                 = 9e3,
  prevalence        = 1 / 9e3,
  contact_rate      = 20,
  transmission_rate = 0.1,
  recovery_rate     = 1 / 7,
  contact_matrix    = cmatrix
) |>
  add_entities_from_dataframe(
    entities = entities,
    col_name = "name",
    col_number = "size",
    # This is passed to `add_entity()`
    as_proportion = FALSE
  )
}
\concept{entity-functions}
